//________________________________________________________________________________________________________
//
//  I2C Support Routines
//________________________________________________________________________________________________________

/*  The ADAU1701 uses 16-bit addressing, so the simple wire instructions aren't adequate.  These routines
 *   provide the 16-bit addressing.  
 *   
 *   The Parameter_1, Parameter_2 and Cmd_Data variables are also used by the SCI routines.  Parameter_1 is the
 *   8-bit I2C address.  Parameter_1_MSB is the extra byte needed for 16-bit addressing.  Parameter_2 is the 
 *   number of bytes to send or read.  The data is in Cmd_Data[].  
 */
 
byte I2C_Read()
  {
    Wire.beginTransmission(I2C_addr); // transmit to device at I2C_addr
    Wire.write(Parameter_1);          //subaddress
    Wire.endTransmission();           //Address counter set
    Wire.requestFrom(I2C_addr,One);   //request one byte
    while (Wire.available()){
      return Wire.read();
    }
  }

byte I2C_16_Read()
  {
    uint8_t addr[] = {Parameter_1_MSB, Parameter_1};
    Wire.beginTransmission(I2C_addr); // transmit to device at I2C_addr
    Wire.write(addr,Two);
    Wire.endTransmission();           //Address counter set
    Wire.requestFrom(I2C_addr,One);   //request one byte
    while (Wire.available()){
      return Wire.read();
    }
  }

void  Get_I2C_block(uint8_t count)
  {
    uint8_t addr[] = {Parameter_1_MSB, Parameter_2};
    Wire.beginTransmission(I2C_addr);   // transmit to device at I2C_addr
    Wire.write(addr,Two);
    //Wire.write (Parameter_1_MSB);     //subaddress MSB
    //Wire.write(Parameter_2);          //subaddress
    Wire.endTransmission(false);           //Address counter set
    Wire.requestFrom(I2C_addr,count,true); //request a block of bytes
    uint8_t x=0;
    while(Wire.available()) Cmd_Data[x++] = Wire.read();   
  }

void  I2C_16_write_M()
  {
   uint8_t addr[7];
   addr[0] = Parameter_1_MSB;
   addr[1] = Parameter_1;
   for (uint8_t x=0; x<Parameter_2; x++) {
        addr[x+2]=Cmd_Data[x];            //copy data into buffer
    }     
   
    Wire.beginTransmission(I2C_addr);     // transmit to device at I2C_addr
    Wire.write(addr,Two+Parameter_2);       //write subaddress followed by data
    Wire.endTransmission();
    //delay(20);
  }

//  The safewrite routine is actually ADAU1701-specific, so it is on the ADAU1701_functions tab.
  
