/*-----------------------------------------------------------------------------------------
   Enums and Structures Used in the HCI and ADAU1466_cmd functions
  ----------------------------------------------------------------------------------------*/


//This structure is used to keep track of which bass_enhancement options are active.  It is used to create a multi-function
//button where the use can cycle through different combinations of bass enhancement
struct bass_enhancement_options {
  bool Rumble_filter_enabled;
  bool Peak_filter_enabled;
  bool SuperBass_enabled;
};

/*Field enunerations that provide a symbolic way of refering to the selected field.  These
   enumerations allow using a Switch - case structure to determine what action needs to
   be taken for each field.  The HCI routine only keeps track of the page and field on
   that page, along with a value.  The tables below convert the value to a displayed value.
   The Update_HW routines provide the code to change the DSP according to the selected value.
   This menu system ensures that the client doesn't need to know anything about the DSP or the
   allowable values */

enum field_ID { Save_Restore,
                EQ_reset_Gain,
                Custom_Reset,
                Main_volume,
                Mute,
                Input,
                chan_vol_T,
                chan_vol_W,
                chan_vol_S,
                Delay_T,
                Delay_W,
                Delay_S,
                BSC_freq,
                BSC_Gain,
                Xover_T_W_type,
                Xover_T_W_freq,
                Xover_W_S_type,
                Xover_W_S_freq,
                Xover_T_W_polarity,
                Xover_W_S_polarity,
                Speaker_select,
                EQ_32_Gain,
                EQ_64_Gain,
                EQ_125_Gain,
                EQ_250_Gain,
                EQ_500_Gain,
                EQ_1K_Gain,
                EQ_2K_Gain,
                EQ_4K_Gain,
                EQ_8K_Gain,
                EQ_16K_Gain,
                Rumble_filter_freq,
                Rumble_filter_Q,
                Peak_filter_freq,
                Peak_filter_Gain,
                Bass_Enhancement_Mode,
                Custom_filter_select,
                Custom_Shared1_Type,
                Custom_Tweeter_Type,
                Custom_Woofer_Type,
                Custom_Sub_Type,
                Custom_Shared1_Freq,
                Custom_Tweeter_Freq,
                Custom_Woofer_Freq,
                Custom_Sub_Freq,
                Custom_Shared1_Q,
                Custom_Tweeter_Q,
                Custom_Woofer_Q,
                Custom_Sub_Q,
                Custom_Shared1_Gain,
                Custom_Tweeter_Gain,
                Custom_Woofer_Gain,
                Custom_Sub_Gain,
                ADAU1466_Source,
                ADAU1466_Freq,
                ADAU1466_Range,
                ADAU1466_Steps,
                ADAU1466_Speed,
                Curvature,
                Shading,
                Last_field_ID  //use this marker to explicitely indicate the number of fields
};


//HCI_state is a table of field structures indexed by the field_ID
struct field {
  byte value;
  byte default_value;
  byte number_of_values;
  byte value_length;
  const char* value_table_pointer;
};

struct commands {
  char command_code;
  byte command_length;
  boolean supported;
};


word biquad_T_W_addresses[5][2] = { { W_LPF1, T_HPF1 },    //Biquad stage 1
                                    { W_LPF2, T_HPF2 },    //Biquad 2 addresses
                                    { W_LPF3, T_HPF3 },    //Biquad 3 addresses
                                    { W_LPF4, T_HPF4 },    //Biquad 4 addresses
                                    { W_LPF5, T_HPF5 } };  //Biquad 5 addresses

word biquad_W_S_addresses[4][2] = { { S_LPF1, W_HPF1 },
                                    { S_LPF2, W_HPF2 },
                                    { S_LPF3, W_HPF3 },
                                    { S_LPF4, W_HPF4 } };

word ADAU1466_Mute_addresses[3] = { T_Mute, W_Mute, S_Mute };
word tweeter_mute_addresses[12] = { MuteT1, MuteT2, MuteT3, MuteT4, MuteT5, MuteT6, MuteT7, MuteT8, MuteT9, MuteT10, MuteT11, MuteT12 };
word woofer_mute_addresses[7] = { MuteW1, MuteW2, MuteW3, MuteW4, MuteW5, MuteW6, MuteW7 };
word tweeter_delay_addresses[12] = { T1_Delay, T2_Delay, T3_Delay, T4_Delay, T5_Delay, T6_Delay, T7_Delay, T8_Delay, T9_Delay, T10_Delay, T11_Delay, T12_Delay };
word woofer_delay_addresses[7] = { W1_Delay, W2_Delay, W3_Delay, W4_Delay, W5_Delay, W6_Delay, W7_Delay };
word tweeter_shading_addresses[12] = { T1_Shade, T2_Shade, T3_Shade, T4_Shade, T5_Shade, T6_Shade, T7_Shade, T8_Shade, T9_Shade, T10_Shade, T11_Shade, T12_Shade };
word woofer_shading_addresses[7] = { W1_Shade, W2_Shade, W3_Shade, W4_Shade, W5_Shade, W6_Shade, W7_Shade };



//word EQ_address[13] = {EQ_32, EQ_64, EQ_125, EQ_250, EQ_500, EQ_1K, EQ_2K, EQ_4K, EQ_8K, EQ_16K, Custom_1, Custom_2, BSC};
