/* This file has the routines to save and restore the system variables from EEPROM.  Data that is saved:
    --The value for each field in the menu.  These values are stored in the first 20 locations.  One byte per value.
    --The HCI page number
    --The IR remote control key mapping.  Each IR action is allocated two bytes--the lower word of the IR value
    --ADAU1466 presets.  Format TBD

    Note:  the data is saved to EEPROM every time the HCI advances to a new page.  This results in relatively few writes
    to the EEPROM, which is important for EEPROM longevity.  However, if the user just changes a value without going to
    a new page, the new value won't get saved.  That's just one of those quirks the user needs to understand...
*/

#include "ADAU1466_cmd.h"
//ADAU1466_cmd myADAU1466_cmd;  //start an instance of the cmd library using the default address

void save_state() {

  Serial.println("Begin Save State  ");

  preferences.begin("Save_main", false);  //open namespace State_Model for read-write
  preferences.putUChar("Volume", HCI_state[Main_volume].value);
  preferences.putUChar("Mute", HCI_state[Mute].value);
  preferences.putUChar("Input", HCI_state[Input].value);

  preferences.putUChar("ch_vol_T", HCI_state[chan_vol_T].value);
  preferences.putUChar("ch_vol_W", HCI_state[chan_vol_W].value);
  preferences.putUChar("ch_vol_S", HCI_state[chan_vol_S].value);

  preferences.putUChar("Delay_T", HCI_state[Delay_T].value);
  preferences.putUChar("Delay_W", HCI_state[Delay_W].value);
  preferences.putUChar("Delay_S", HCI_state[Delay_S].value);

  preferences.putUChar("BSC_freq", HCI_state[BSC_freq].value);
  preferences.putUChar("BSC_Gain", HCI_state[BSC_Gain].value);

  preferences.putUChar("X_TW_T", HCI_state[Xover_T_W_type].value);
  preferences.putUChar("X_TW_F", HCI_state[Xover_T_W_freq].value);
  preferences.putUChar("X_WS_T", HCI_state[Xover_W_S_type].value);
  preferences.putUChar("X_WS_F", HCI_state[Xover_W_S_freq].value);

  preferences.putUChar("X_T_P", HCI_state[Xover_T_W_polarity].value);
  preferences.putUChar("X_W_P", HCI_state[Xover_W_S_polarity].value);

  preferences.putUChar("EQ_32", HCI_state[EQ_32_Gain].value);
  preferences.putUChar("EQ_64", HCI_state[EQ_64_Gain].value);
  preferences.putUChar("EQ_125", HCI_state[EQ_125_Gain].value);
  preferences.putUChar("EQ_250", HCI_state[EQ_250_Gain].value);
  preferences.putUChar("EQ_500", HCI_state[EQ_500_Gain].value);
  preferences.putUChar("EQ_1K", HCI_state[EQ_1K_Gain].value);
  preferences.putUChar("EQ_2K", HCI_state[EQ_2K_Gain].value);
  preferences.putUChar("EQ_4K", HCI_state[EQ_4K_Gain].value);
  preferences.putUChar("EQ_8K", HCI_state[EQ_8K_Gain].value);
  preferences.putUChar("EQ_16K", HCI_state[EQ_16K_Gain].value);

  preferences.putUChar("Rumble_freq", HCI_state[Rumble_filter_freq].value);
  preferences.putUChar("Rumble_Q", HCI_state[Rumble_filter_Q].value);
  preferences.putUChar("Bass_Mode", HCI_state[Bass_Enhancement_Mode].value);
  preferences.putUChar("Peak_freq", HCI_state[Peak_filter_freq].value);
  preferences.putUChar("Peak_Gain", HCI_state[Peak_filter_Gain].value);

  preferences.putUChar("Curvature", HCI_state[Curvature].value);
  preferences.putUChar("Shading", HCI_state[Shading].value);

  //preferences.putUChar("SB_freq", HCI_state[SuperBass_freq].value);
  //preferences.putUChar("SB_Intensity", HCI_state[SuperBass_Intensity].value);
  //preferences.putUChar("SB_Gain", HCI_state[SuperBass_Gain].value);

  //preferences.putUChar("DB_Threshold", HCI_state[Dynamic_Bass_Threshold].value);
  //preferences.putUChar("DB_Time_Const", HCI_state[Dynamic_Bass_Time_constant].value);
  //preferences.putUChar("DB_Boost", HCI_state[Dynamic_Bass_Boost].value);
  //preferences.putUChar("DB_Freq", HCI_state[Dynamic_Bass_Frequency].value);

  preferences.putUChar("Shared1_Type", HCI_state[Custom_Shared1_Type].value);
  preferences.putUChar("Shared1_Freq", HCI_state[Custom_Shared1_Freq].value);
  preferences.putUChar("Shared1_Q", HCI_state[Custom_Shared1_Q].value);
  preferences.putUChar("Shared1_Gain", HCI_state[Custom_Shared1_Gain].value);

  preferences.putUChar("T_Type", HCI_state[Custom_Tweeter_Type].value);
  preferences.putUChar("T_Freq", HCI_state[Custom_Tweeter_Freq].value);
  preferences.putUChar("T_Q", HCI_state[Custom_Tweeter_Q].value);
  preferences.putUChar("T_Gain", HCI_state[Custom_Tweeter_Gain].value);

  preferences.putUChar("W_Type", HCI_state[Custom_Woofer_Type].value);
  preferences.putUChar("W_Freq", HCI_state[Custom_Woofer_Freq].value);
  preferences.putUChar("W_Q", HCI_state[Custom_Woofer_Q].value);
  preferences.putUChar("W_Gain", HCI_state[Custom_Woofer_Gain].value);

  preferences.putUChar("S_Type", HCI_state[Custom_Sub_Type].value);
  preferences.putUChar("S_Freq", HCI_state[Custom_Sub_Freq].value);
  preferences.putUChar("S_Q", HCI_state[Custom_Sub_Q].value);
  preferences.putUChar("S_Gain", HCI_state[Custom_Sub_Gain].value);

  preferences.end();
  Serial.print("state_saved");
}

void save_state_a() {
  //reserved for saving another set of values
}



void restore_state() {
  preferences.begin("Save_main", true);  //open namespace State_Model for read only

  HCI_state[Main_volume].value = preferences.getUChar("Volume", HCI_state[Main_volume].default_value);
  HCI_state[Mute].value = preferences.getUChar("Mute", HCI_state[Mute].default_value);
  HCI_state[Input].value = preferences.getUChar("Input", HCI_state[Input].default_value);

  HCI_state[chan_vol_T].value = preferences.getUChar("ch_vol_T", HCI_state[chan_vol_T].default_value);
  HCI_state[chan_vol_W].value = preferences.getUChar("ch_vol_W", HCI_state[chan_vol_W].default_value);
  HCI_state[chan_vol_S].value = preferences.getUChar("ch_vol_S", HCI_state[chan_vol_S].default_value);

  HCI_state[Delay_T].value = preferences.getUChar("Delay_T", HCI_state[Delay_T].default_value);
  HCI_state[Delay_W].value = preferences.getUChar("Delay_W", HCI_state[Delay_W].default_value);
  HCI_state[Delay_S].value = preferences.getUChar("Delay_S", HCI_state[Delay_S].default_value);

  HCI_state[BSC_freq].value = preferences.getUChar("BSC_freq", HCI_state[BSC_freq].default_value);
  HCI_state[BSC_Gain].value = preferences.getUChar("BSC_Gain", HCI_state[BSC_Gain].default_value);

  HCI_state[Xover_T_W_type].value = preferences.getUChar("X_TW_T", HCI_state[Xover_T_W_type].default_value);
  HCI_state[Xover_T_W_freq].value = preferences.getUChar("X_TW_F", HCI_state[Xover_T_W_freq].default_value);
  HCI_state[Xover_W_S_type].value = preferences.getUChar("X_WS_T", HCI_state[Xover_W_S_type].default_value);
  HCI_state[Xover_W_S_freq].value = preferences.getUChar("X_WS_F", HCI_state[Xover_W_S_freq].default_value);

  HCI_state[Xover_T_W_polarity].value = preferences.getUChar("X_T_P", HCI_state[Xover_T_W_polarity].default_value);
  HCI_state[Xover_W_S_polarity].value = preferences.getUChar("X_W_P", HCI_state[Xover_W_S_polarity].default_value);

  HCI_state[EQ_32_Gain].value = preferences.getUChar("EQ_32", HCI_state[EQ_32_Gain].default_value);
  HCI_state[EQ_64_Gain].value = preferences.getUChar("EQ_64", HCI_state[EQ_64_Gain].default_value);
  HCI_state[EQ_125_Gain].value = preferences.getUChar("EQ_125", HCI_state[EQ_125_Gain].default_value);
  HCI_state[EQ_250_Gain].value = preferences.getUChar("EQ_250", HCI_state[EQ_250_Gain].default_value);
  HCI_state[EQ_500_Gain].value = preferences.getUChar("EQ_500", HCI_state[EQ_500_Gain].default_value);
  HCI_state[EQ_1K_Gain].value = preferences.getUChar("EQ_1K", HCI_state[EQ_1K_Gain].default_value);
  HCI_state[EQ_2K_Gain].value = preferences.getUChar("EQ_2K", HCI_state[EQ_2K_Gain].default_value);
  HCI_state[EQ_4K_Gain].value = preferences.getUChar("EQ_48K", HCI_state[EQ_4K_Gain].default_value);
  HCI_state[EQ_8K_Gain].value = preferences.getUChar("EQ_8K", HCI_state[EQ_8K_Gain].default_value);
  HCI_state[EQ_16K_Gain].value = preferences.getUChar("EQ_16K", HCI_state[EQ_16K_Gain].default_value);

  HCI_state[Rumble_filter_freq].value = preferences.getUChar("Rumble_freq", HCI_state[Rumble_filter_freq].default_value);
  HCI_state[Rumble_filter_Q].value = preferences.getUChar("Rumble_Q", HCI_state[Rumble_filter_Q].default_value);
  HCI_state[Bass_Enhancement_Mode].value = preferences.getUChar("Bass_Mode", HCI_state[Bass_Enhancement_Mode].default_value);
  HCI_state[Peak_filter_freq].value = preferences.getUChar("Peak_freq", HCI_state[Peak_filter_freq].default_value);
  HCI_state[Peak_filter_Gain].value = preferences.getUChar("Peak_Gain", HCI_state[Peak_filter_Gain].default_value);

  HCI_state[Curvature].value = preferences.getUChar("Curvature", HCI_state[Curvature].default_value);
  HCI_state[Shading].value = preferences.getUChar("Shading", HCI_state[Shading].default_value);


  //HCI_state[SuperBass_freq].value = preferences.getUChar("SB_freq", HCI_state[SuperBass_freq].default_value);
  //HCI_state[SuperBass_Intensity].value = preferences.getUChar("SB_Intensity", HCI_state[SuperBass_Intensity].default_value);
  //HCI_state[SuperBass_Gain].value = preferences.getUChar("SB_Gain", HCI_state[SuperBass_Gain].default_value);

  //HCI_state[Dynamic_Bass_Threshold].value = preferences.getUChar("DB_Threshold", HCI_state[Dynamic_Bass_Threshold].default_value);
  //HCI_state[Dynamic_Bass_Time_constant].value = preferences.getUChar("DB_Time_Constant", HCI_state[Dynamic_Bass_Time_constant].default_value);
  //HCI_state[Dynamic_Bass_Boost].value = preferences.getUChar("DB_Boost", HCI_state[Dynamic_Bass_Boost].default_value);
  //HCI_state[Dynamic_Bass_Frequency].value = preferences.getUChar("DB_Freq", HCI_state[Dynamic_Bass_Frequency].default_value);

  HCI_state[Custom_Shared1_Type].value = preferences.getUChar("Shared1_Type", HCI_state[Custom_Shared1_Type].default_value);
  HCI_state[Custom_Shared1_Freq].value = preferences.getUChar("Shared1_Freq", HCI_state[Custom_Shared1_Freq].default_value);
  HCI_state[Custom_Shared1_Q].value = preferences.getUChar("Shared1_Q", HCI_state[Custom_Shared1_Q].default_value);
  HCI_state[Custom_Shared1_Gain].value = preferences.getUChar("Shared1_Gain", HCI_state[Custom_Shared1_Gain].default_value);

  HCI_state[Custom_Tweeter_Type].value = preferences.getUChar("T_Type", HCI_state[Custom_Tweeter_Type].default_value);
  HCI_state[Custom_Tweeter_Freq].value = preferences.getUChar("T_Freq", HCI_state[Custom_Tweeter_Freq].default_value);
  HCI_state[Custom_Tweeter_Q].value = preferences.getUChar("T_Q", HCI_state[Custom_Tweeter_Q].default_value);
  HCI_state[Custom_Tweeter_Gain].value = preferences.getUChar("T_Gain", HCI_state[Custom_Tweeter_Gain].default_value);

  HCI_state[Custom_Woofer_Type].value = preferences.getUChar("W_Type", HCI_state[Custom_Woofer_Type].default_value);
  HCI_state[Custom_Woofer_Freq].value = preferences.getUChar("W_Freq", HCI_state[Custom_Woofer_Freq].default_value);
  HCI_state[Custom_Woofer_Q].value = preferences.getUChar("W_Q", HCI_state[Custom_Woofer_Q].default_value);
  HCI_state[Custom_Woofer_Gain].value = preferences.getUChar("W_Gain", HCI_state[Custom_Woofer_Gain].default_value);

  HCI_state[Custom_Sub_Type].value = preferences.getUChar("S_Type", HCI_state[Custom_Sub_Type].default_value);
  HCI_state[Custom_Sub_Freq].value = preferences.getUChar("S_Freq", HCI_state[Custom_Sub_Freq].default_value);
  HCI_state[Custom_Sub_Q].value = preferences.getUChar("S_Q", HCI_state[Custom_Sub_Q].default_value);
  HCI_state[Custom_Sub_Gain].value = preferences.getUChar("S_Gain", HCI_state[Custom_Sub_Gain].default_value);

  preferences.end();

  //Now reload all values

  for (int i = Main_volume; i < Last_field_ID; i++) {     //skip over "Save/Restore" and resets
  //Last_field_ID

    update_from_HCI(i, HCI_state[i].value);
    //delay(500);
    //if(i>60) delay(2000);

  }
}

void restore_state_a() {
  //reserved for restoring another set of values
}
