void read_vendor_ID(uint8_t IC_address) {
  Wire.beginTransmission(IC_address);  // Get the SSM3582's attention, tell it we're sending a command byte
  Wire.write(0);
  Wire.endTransmission(false);            // Point to register 0 (Vendor ID)
  Wire.requestFrom(IC_address, 2, true);  // Set up read 1 byte from the current register
  byte slaveByte1 = Wire.read();          // read that byte into 'slaveByte1' variable
  byte slaveByte2 = Wire.read();          // read that byte into 'slaveByte1' variable
  //Wire.endTransmission(false);                     // Terminate the transaction
  Serial.print("Device ID = ");
  Serial.print(slaveByte1, HEX);
  Serial.println(slaveByte2, HEX);
}

uint8_t read_SSM3582(uint8_t IC_address, uint8_t reg) {
  Wire.beginTransmission(IC_address);  // Get the SSM3582's attention, tell it we're sending a command byte
  Wire.write(reg);
  Wire.endTransmission(false);            // Point to register
  Wire.requestFrom(IC_address, 1, true);  // Set up read 1 byte from the current register
  return Wire.read();                     // return that byte
}

void check_SSM3582(uint8_t IC_address[number_of_SSM3582_chips]) {
  for (int i = 0; i < number_of_SSM3582_chips; i++) {
    uint8_t vendor_ID0 = read_SSM3582(IC_address[i], 0);
    Serial.print("I2C address = ");
    Serial.print(IC_address[i], HEX);
    Serial.print("  Data = ");
    Serial.println(vendor_ID0, HEX);
  }
}


bool init_SSM3582(uint8_t SSM3582_I2C_addresses[number_of_SSM3582_chips]) {
  int slot_counter = 0;
  int maxslots[10] = { 8, 8, 8, 8, 4, 4, 8, 8, 8, 8 };
  for (int i = 0; i < number_of_SSM3582_chips; i++) {

    Wire.beginTransmission(SSM3582_I2C_addresses[i]);   // transmit to device at chip #1
    Wire.write(4);                                      //start at register 4
    Wire.write(0x80);                                   //(4)  POWER_CTRL: turn on the device with auto power-down enabled
    Wire.write(0x0B);                                   //(5)  AMP_DAC_CTRL:  +21dB gain, with low EMI
    Wire.write(0x02);                                   //(6)  DAC_CTRL:  48KHz, no mute
    Wire.write(0x40);                                   //(7)  VOL_LEFT_CTR:  0dB
    Wire.write(0x40);                                   //(8)  VOL_RIGHT_CTR:  0dB
    Wire.write(0x17);                                   //(9)  SAI_CTRL1:  TDM mode, Left justified
    Wire.write(0x06);                                   //(A)  SAI_CTRL2:  TDM mode with Limiter and Clip linked
    Wire.write(slot_counter);                           //(B)  SLOT_LEFT_CTRL: use the slot counter
    slot_counter = slot_counter + 1;                    //bump the counter
    Wire.write(slot_counter);                           //(C)  SLOT_RIGHT_CTRL: use the slot counter
    slot_counter = slot_counter + 1;                    //bump the counter
    if (slot_counter >= maxslots[i]) slot_counter = 0;  //check for overflow
    Wire.write(0x00);                                   //(D)  Dummy write to non-existent register D
    Wire.write(0x00);                                   //(E)  Turn off the limiters

    //Skip over limiter, clipping and temp controls for now
    Wire.endTransmission(true);
    delay(50);
  }
  return true;
}

word check_SSM3582_status(uint8_t SSM3582_I2C_address) {
  uint8_t status_reg1 = 0x18;
  uint8_t status_reg2 = 0x19;
  word status_bits = read_SSM3582(SSM3582_I2C_address, status_reg1);
  status_bits <<= 8;                                                           //move bits to MSB
  status_bits = status_bits | read_SSM3582(SSM3582_I2C_address, status_reg2);  //merge in status reg 2
  return status_bits;
}

bool check_SSM3582_power_on(uint8_t SSM3582_I2C_address) {
  bool status = false;    //assume amp is off
  uint8_t POWER_CTRL_reg1 = 0x04;
  uint8_t status_bits = read_SSM3582(SSM3582_I2C_address, POWER_CTRL_reg1);
  status_bits = status_bits & 0x0C;
  if(status_bits == 0) status = true;
  return status;
}

void check_SSM3582_power(uint8_t SSM3582_I2C_address) {
  uint8_t POWER_CTRL_reg1 = 0x04;
  uint8_t status_bits = read_SSM3582(SSM3582_I2C_address, POWER_CTRL_reg1);
        Serial.print("  POWER_CTRL = ");
        Serial.println(status_bits, HEX);
}

int reset_SSM3582(uint8_t SSM3582_I2C_addresses[number_of_SSM3582_chips]) {
  return 1;
}
