#include "HCI.h"

/*  Routines to initialize and update the HCI state

  The HCI state is held in an array of "field" structures.  Each field has the default value, the current value, the pointer
   * to a value table, and the number of values and the length of the displayed value.

/*For reference--these are the fields for one variant of this code.  The actual fields are enumerated in the file enum_struct.h
 * Main_volume, Mute, chan_vol_L_Tweeter, chan_vol_R_Tweeter, chan_vol_L_Woofer, chan_vol_R_Woofer, chan_vol_L_Sub, chan_vol_R_Sub, Delay_L_Tweeter, Delay_R_Tweeter,
  Delay_L_Woofer, Delay_R_Woofer, BSC_freq, BSC_Gain, Xover_TW_type, Xover_TW_freq, Xover_WS_type, Xover_WS_freq, EQ_50_Gain, EQ_80_Gain,
  EQ_300_Gain, EQ_600_Gain, EQ_900_Gain, EQ_2K_Gain, EQ_5K_Gain, EQ_8K_Gain, EQ_13K_Gain, EQ_reset_Gain, Xover_T_polarity, Xover_S_polarity,
  Rumble_filter_freq, Rumble_filter_Q, Bass_Enhancement_Mode, Peak_filter_freq, Peak_filter_Gain, SuperBass_freq, SuperBass_Intensity, SuperBass_Gain,
  Custom_filter, Custom_Shared1_Type, Custom_Shared2_Type, Custom_Tweeter_Type, Custom_Woofer_Type, Custom_Sub_Type,
  Custom_Shared1_Freq, Custom_Shared2_Freq, Custom_Tweeter_Freq, Custom_Woofer_Freq, Custom_Sub_Freq,
  Custom_Shared1_Q,  Custom_Shared2_Q, Custom_Tweeter_Q, Custom_Woofer_Q, Custom_Sub_Q,
  Custom_Shared1_Gain, Custom_Shared2_Gain, Custom_Tweeter_Gain, Custom_Woofer_Gain, Custom_Sub_Gain,
  Last_field_ID    //need this marker to know how many fields there are
*/

void  HCI_init() {
  HCI_state[Input].default_value = 0;    //default value for input = Bluetooth
  HCI_state[Input].value = HCI_state[Input].default_value;
  HCI_state[Input].value_table_pointer = &input_values[0][0];
  HCI_state[Input].number_of_values = input_value_qty;
  HCI_state[Input].value_length = input_value_len;
  
  HCI_state[Main_volume].default_value = 78;    //default value for volume = 0
  HCI_state[Main_volume].value = HCI_state[Main_volume].default_value;
  HCI_state[Main_volume].value_table_pointer = &vol_values[0][0];
  HCI_state[Main_volume].number_of_values = vol_value_qty;
  HCI_state[Main_volume].value_length = vol_value_len;

  HCI_state[Mute].default_value = 0;    //default value for mute = off
  HCI_state[Mute].value = HCI_state[Mute].default_value;
  HCI_state[Mute].value_table_pointer = &mute_values[0][0];
  HCI_state[Mute].number_of_values = mute_value_qty;
  HCI_state[Mute].value_length = mute_value_len;

  HCI_state[chan_vol_T].default_value = 10;    //default trim  = 0dB
  HCI_state[chan_vol_T].value = HCI_state[chan_vol_T].default_value;
  HCI_state[chan_vol_T].value_table_pointer = &chan_trim_values[0][0];
  HCI_state[chan_vol_T].number_of_values = chan_trim_qty;
  HCI_state[chan_vol_T].value_length = chan_trim_len;

  HCI_state[chan_vol_W].default_value = 10;    //default trim  = 0
  HCI_state[chan_vol_W].value = HCI_state[chan_vol_W].default_value;
  HCI_state[chan_vol_W].value_table_pointer = &chan_trim_values[0][0];
  HCI_state[chan_vol_W].number_of_values = chan_trim_qty;
  HCI_state[chan_vol_W].value_length = chan_trim_len;

  HCI_state[chan_vol_S].default_value = 10;    //default trim  = 0
  HCI_state[chan_vol_S].value = HCI_state[chan_vol_S].default_value;
  HCI_state[chan_vol_S].value_table_pointer = &chan_trim_values[0][0];
  HCI_state[chan_vol_S].number_of_values = chan_trim_qty;
  HCI_state[chan_vol_S].value_length = chan_trim_len;

  HCI_state[Delay_T].default_value = 0;    //default delay  = 0
  HCI_state[Delay_T].value = HCI_state[Delay_T].default_value;
  HCI_state[Delay_T].value_table_pointer = &delay_values[0][0];
  HCI_state[Delay_T].number_of_values = delay_values_qty;
  HCI_state[Delay_T].value_length = delay_values_len;

  HCI_state[Delay_W].default_value = 0;    //default delay  = 0
  HCI_state[Delay_W].value = HCI_state[Delay_W].default_value;
  HCI_state[Delay_W].value_table_pointer = &delay_values[0][0];
  HCI_state[Delay_W].number_of_values = delay_values_qty;
  HCI_state[Delay_W].value_length = delay_values_len;

  HCI_state[Delay_S].default_value = 0;    //default delay  = 0
  HCI_state[Delay_S].value = HCI_state[Delay_S].default_value;
  HCI_state[Delay_S].value_table_pointer = &delay_values[0][0];
  HCI_state[Delay_S].number_of_values = delay_values_qty;
  HCI_state[Delay_S].value_length = delay_values_len;


  HCI_state[BSC_freq].default_value = 4;    //default BSC Freq = 700Hz
  HCI_state[BSC_freq].value = HCI_state[BSC_freq].default_value;
  HCI_state[BSC_freq].value_table_pointer = &BSC_freq_values[0][0];
  HCI_state[BSC_freq].number_of_values = BSC_freq_qty;
  HCI_state[BSC_freq].value_length = BSC_freq_len;

  HCI_state[BSC_Gain].default_value = 4;    //default BSC gain value = 4dB
  HCI_state[BSC_Gain].value = HCI_state[BSC_Gain].default_value;
  HCI_state[BSC_Gain].value_table_pointer = &BSC_gain_values[0][0];
  HCI_state[BSC_Gain].number_of_values = BSC_gain_qty;
  HCI_state[BSC_Gain].value_length = BSC_gain_len;

  HCI_state[Xover_T_W_type].default_value = 1;     //default Xover = BW1
  HCI_state[Xover_T_W_type].value = HCI_state[Xover_T_W_type].default_value;
  HCI_state[Xover_T_W_type].value_table_pointer = &Xover_T_W_type_values[0][0];
  HCI_state[Xover_T_W_type].number_of_values = Xover_T_W_type_qty;
  HCI_state[Xover_T_W_type].value_length = Xover_T_W_type_len;

  HCI_state[Xover_T_W_freq].default_value = 2;     //default Xover freq = 2000
  HCI_state[Xover_T_W_freq].value = HCI_state[Xover_T_W_freq].default_value;
  HCI_state[Xover_T_W_freq].value_table_pointer = &Xover_T_W_freq_values[0][0];
  HCI_state[Xover_T_W_freq].number_of_values = Xover_T_W_freq_qty;
  HCI_state[Xover_T_W_freq].value_length = Xover_T_W_freq_len;

  HCI_state[Xover_W_S_type].default_value = 1;     //default Xover = BW1
  HCI_state[Xover_W_S_type].value = HCI_state[Xover_W_S_type].default_value;
  HCI_state[Xover_W_S_type].value_table_pointer = &Xover_W_S_type_values[0][0];
  HCI_state[Xover_W_S_type].number_of_values = Xover_W_S_type_qty;
  HCI_state[Xover_W_S_type].value_length = Xover_W_S_type_len;

  HCI_state[Xover_W_S_freq].default_value = 2;     //default Xover freq = 2000
  HCI_state[Xover_W_S_freq].value = HCI_state[Xover_W_S_freq].default_value;
  HCI_state[Xover_W_S_freq].value_table_pointer = &Xover_W_S_freq_values[0][0];
  HCI_state[Xover_W_S_freq].number_of_values = Xover_W_S_freq_qty;
  HCI_state[Xover_W_S_freq].value_length = Xover_W_S_freq_len;

  HCI_state[Xover_T_W_polarity].default_value = 0;         //default polarity = +
  HCI_state[Xover_T_W_polarity].value = HCI_state[Xover_T_W_polarity].default_value;
  HCI_state[Xover_T_W_polarity].value_table_pointer = &Xover_T_W_polarity_values[0][0];
  HCI_state[Xover_T_W_polarity].number_of_values = Xover_T_W_polarity_qty;
  HCI_state[Xover_T_W_polarity].value_length = Xover_T_W_polarity_len;

  HCI_state[Xover_W_S_polarity].default_value = 0;    //default BSC gain value = 4dB
  HCI_state[Xover_W_S_polarity].value = HCI_state[Xover_W_S_polarity].default_value;
  HCI_state[Xover_W_S_polarity].value_table_pointer = &Xover_W_S_polarity_values[0][0];
  HCI_state[Xover_W_S_polarity].number_of_values = Xover_W_S_polarity_qty;
  HCI_state[Xover_W_S_polarity].value_length = Xover_W_S_polarity_len;

  HCI_state[Rumble_filter_freq].default_value = 4;    //default Bass_filters_freq = 30Hz
  HCI_state[Rumble_filter_freq].value = HCI_state[Rumble_filter_freq].default_value;
  HCI_state[Rumble_filter_freq].value_table_pointer = &Bass_filters_freq_values[0][0];
  HCI_state[Rumble_filter_freq].number_of_values = Bass_filters_freq_qty;
  HCI_state[Rumble_filter_freq].value_length = Bass_filters_freq_len;

  HCI_state[Rumble_filter_Q].default_value = 1;    //default Bass_filters_Q = .7
  HCI_state[Rumble_filter_Q].value = HCI_state[Rumble_filter_Q].default_value;
  HCI_state[Rumble_filter_Q].value_table_pointer = &Bass_filters_Q_values[0][0];
  HCI_state[Rumble_filter_Q].number_of_values = Bass_filters_Q_qty;
  HCI_state[Rumble_filter_Q].value_length = Bass_filters_Q_len;

  HCI_state[Bass_Enhancement_Mode].default_value = 1;    //default Bass_enhancement = Rumble Filter
  HCI_state[Bass_Enhancement_Mode].value = HCI_state[Bass_Enhancement_Mode].default_value;
  HCI_state[Bass_Enhancement_Mode].value_table_pointer = &Bass_Enhancement_Mode_values[0][0];
  HCI_state[Bass_Enhancement_Mode].number_of_values = Bass_Enhancement_Mode_qty;
  HCI_state[Bass_Enhancement_Mode].value_length = Bass_Enhancement_Mode_len;

  HCI_state[Peak_filter_freq].default_value = 4;    //default Bass_filters_freq = 30Hz
  HCI_state[Peak_filter_freq].value = HCI_state[Peak_filter_freq].default_value;
  HCI_state[Peak_filter_freq].value_table_pointer = &Bass_filters_freq_values[0][0];
  HCI_state[Peak_filter_freq].number_of_values = Bass_filters_freq_qty;
  HCI_state[Peak_filter_freq].value_length = Bass_filters_freq_len;

  HCI_state[Peak_filter_Gain].default_value = 1;    //default Bass_filters_Q = .7
  HCI_state[Peak_filter_Gain].value = HCI_state[Peak_filter_Gain].default_value;
  HCI_state[Peak_filter_Gain].value_table_pointer = &Bass_filters_Gain_values[0][0];
  HCI_state[Peak_filter_Gain].number_of_values = Bass_filters_Gain_qty;
  HCI_state[Peak_filter_Gain].value_length = Bass_filters_Gain_len;


  HCI_state[EQ_32_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_32_Gain].value = HCI_state[EQ_32_Gain].default_value;
  HCI_state[EQ_32_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_32_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_32_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_64_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_64_Gain].value = HCI_state[EQ_64_Gain].default_value;
  HCI_state[EQ_64_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_64_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_64_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_125_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_125_Gain].value = HCI_state[EQ_125_Gain].default_value;
  HCI_state[EQ_125_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_125_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_125_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_250_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_250_Gain].value = HCI_state[EQ_250_Gain].default_value;
  HCI_state[EQ_250_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_250_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_250_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_500_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_500_Gain].value = HCI_state[EQ_500_Gain].default_value;
  HCI_state[EQ_500_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_500_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_500_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_1K_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_1K_Gain].value = HCI_state[EQ_1K_Gain].default_value;
  HCI_state[EQ_1K_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_1K_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_1K_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_2K_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_2K_Gain].value = HCI_state[EQ_2K_Gain].default_value;
  HCI_state[EQ_2K_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_2K_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_2K_Gain].value_length = EQ_gain_len;
  
  HCI_state[EQ_4K_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_4K_Gain].value = HCI_state[EQ_4K_Gain].default_value;
  HCI_state[EQ_4K_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_4K_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_4K_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_8K_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_8K_Gain].value = HCI_state[EQ_8K_Gain].default_value;
  HCI_state[EQ_8K_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_8K_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_8K_Gain].value_length = EQ_gain_len;

  HCI_state[EQ_16K_Gain].default_value = 5;     //default gain = 0
  HCI_state[EQ_16K_Gain].value = HCI_state[EQ_16K_Gain].default_value;
  HCI_state[EQ_16K_Gain].value_table_pointer = &EQ_gain_values[0][0];
  HCI_state[EQ_16K_Gain].number_of_values = EQ_gain_qty;
  HCI_state[EQ_16K_Gain].value_length = EQ_gain_len;

  HCI_state[ADAU1466_Source].default_value = 4;     //default source = Mute
  HCI_state[ADAU1466_Source].value = HCI_state[ADAU1466_Source].default_value;
  HCI_state[ADAU1466_Source].value_table_pointer = &ADAU1466_Source_values[0][0];
  HCI_state[ADAU1466_Source].number_of_values = ADAU1466_Source_qty;
  HCI_state[ADAU1466_Source].value_length = ADAU1466_Source_len;

  HCI_state[ADAU1466_Freq].default_value = 5;     //default Freq = 1000Hz
  HCI_state[ADAU1466_Freq].value = HCI_state[ADAU1466_Freq].default_value;
  HCI_state[ADAU1466_Freq].value_table_pointer = &ADAU1466_Freq_values[0][0];
  HCI_state[ADAU1466_Freq].number_of_values = ADAU1466_Freq_qty;
  HCI_state[ADAU1466_Freq].value_length = ADAU1466_Freq_len;

  HCI_state[ADAU1466_Range].default_value = 0;     //default Range = 20 to 20000Hz
  HCI_state[ADAU1466_Range].value = HCI_state[ADAU1466_Range].default_value;
  HCI_state[ADAU1466_Range].value_table_pointer = &ADAU1466_Range_values[0][0];
  HCI_state[ADAU1466_Range].number_of_values = ADAU1466_Range_qty;
  HCI_state[ADAU1466_Range].value_length = ADAU1466_Range_len;

  HCI_state[ADAU1466_Steps].default_value = 0;     //default Steps = 10
  HCI_state[ADAU1466_Steps].value = HCI_state[ADAU1466_Steps].default_value;
  HCI_state[ADAU1466_Steps].value_table_pointer = &ADAU1466_Steps_values[0][0];
  HCI_state[ADAU1466_Steps].number_of_values = ADAU1466_Steps_qty;
  HCI_state[ADAU1466_Steps].value_length = ADAU1466_Steps_len;

  HCI_state[ADAU1466_Speed].default_value = 0;     //default Speed = 5ms
  HCI_state[ADAU1466_Speed].value = HCI_state[ADAU1466_Speed].default_value;
  HCI_state[ADAU1466_Speed].value_table_pointer = &ADAU1466_Speed_values[0][0];
  HCI_state[ADAU1466_Speed].number_of_values = ADAU1466_Speed_qty;
  HCI_state[ADAU1466_Speed].value_length = ADAU1466_Speed_len;


  HCI_state[Custom_filter_select].default_value = 0;     //default filter = Shared_1
  HCI_state[Custom_filter_select].value = HCI_state[Custom_filter_select].default_value;
  HCI_state[Custom_filter_select].value_table_pointer = &Custom_filter_select_values[0][0];
  HCI_state[Custom_filter_select].number_of_values = Custom_filter_select_qty;
  HCI_state[Custom_filter_select].value_length = Custom_filter_select_len;

  HCI_state[Custom_Shared1_Type].default_value = 10;     //default filter = none
  HCI_state[Custom_Shared1_Type].value = HCI_state[Custom_Shared1_Type].default_value;
  HCI_state[Custom_Shared1_Type].value_table_pointer = &Custom_type_values[0][0];
  HCI_state[Custom_Shared1_Type].number_of_values = Custom_type_qty;
  HCI_state[Custom_Shared1_Type].value_length = Custom_type_len;

  HCI_state[Custom_Shared1_Freq].default_value = 0;     //default freq
  HCI_state[Custom_Shared1_Freq].value = HCI_state[Custom_Shared1_Freq].default_value;
  HCI_state[Custom_Shared1_Freq].value_table_pointer = &Custom_freq_values[0][0];
  HCI_state[Custom_Shared1_Freq].number_of_values = Custom_freq_qty;
  HCI_state[Custom_Shared1_Freq].value_length = Custom_freq_len;

  HCI_state[Custom_Shared1_Q].default_value = 2;     //default Q = .7
  HCI_state[Custom_Shared1_Q].value = HCI_state[Custom_Shared1_Q].default_value;
  HCI_state[Custom_Shared1_Q].value_table_pointer = &Bass_filters_Q_values[0][0];       //use Bass Filters Q table
  HCI_state[Custom_Shared1_Q].number_of_values = Bass_filters_Q_qty;
  HCI_state[Custom_Shared1_Q].value_length = Bass_filters_Q_len;

  HCI_state[Custom_Shared1_Gain].default_value = 13;     //default gain = 0
  HCI_state[Custom_Shared1_Gain].value = HCI_state[Custom_Shared1_Gain].default_value;
  HCI_state[Custom_Shared1_Gain].value_table_pointer = &Custom_gain_values[0][0];
  HCI_state[Custom_Shared1_Gain].number_of_values = Custom_gain_qty;
  HCI_state[Custom_Shared1_Gain].value_length = Custom_gain_len;

  HCI_state[Custom_Tweeter_Type].default_value = 10;     //default filter = none
  HCI_state[Custom_Tweeter_Type].value = HCI_state[Custom_Tweeter_Type].default_value;
  HCI_state[Custom_Tweeter_Type].value_table_pointer = &Custom_type_values[0][0];
  HCI_state[Custom_Tweeter_Type].number_of_values = Custom_type_qty;
  HCI_state[Custom_Tweeter_Type].value_length = Custom_type_len;

  HCI_state[Custom_Tweeter_Freq].default_value = 0;     //default freq = 500Hz
  HCI_state[Custom_Tweeter_Freq].value = HCI_state[Custom_Tweeter_Freq].default_value;
  HCI_state[Custom_Tweeter_Freq].value_table_pointer = &Custom_tweeter_freq_values[0][0];
  HCI_state[Custom_Tweeter_Freq].number_of_values = Custom_tweeter_freq_qty;
  HCI_state[Custom_Tweeter_Freq].value_length = Custom_tweeter_freq_len;

  HCI_state[Custom_Tweeter_Q].default_value = 2;     //default Q = .7
  HCI_state[Custom_Tweeter_Q].value = HCI_state[Custom_Tweeter_Q].default_value;
  HCI_state[Custom_Tweeter_Q].value_table_pointer = &Bass_filters_Q_values[0][0];       //use Bass Filters Q table
  HCI_state[Custom_Tweeter_Q].number_of_values = Bass_filters_Q_qty;
  HCI_state[Custom_Tweeter_Q].value_length = Bass_filters_Q_len;

  HCI_state[Custom_Tweeter_Gain].default_value = 13;     //default gain = 0
  HCI_state[Custom_Tweeter_Gain].value = HCI_state[Custom_Tweeter_Gain].default_value;
  HCI_state[Custom_Tweeter_Gain].value_table_pointer = &Custom_gain_values[0][0];
  HCI_state[Custom_Tweeter_Gain].number_of_values = Custom_gain_qty;
  HCI_state[Custom_Tweeter_Gain].value_length = Custom_gain_len;

  HCI_state[Custom_Woofer_Type].default_value = 10;     //default filter = none
  HCI_state[Custom_Woofer_Type].value = HCI_state[Custom_Woofer_Type].default_value;
  HCI_state[Custom_Woofer_Type].value_table_pointer = &Custom_type_values[0][0];
  HCI_state[Custom_Woofer_Type].number_of_values = Custom_type_qty;
  HCI_state[Custom_Woofer_Type].value_length = Custom_type_len;

  HCI_state[Custom_Woofer_Freq].default_value = 10;     //default freq
  HCI_state[Custom_Woofer_Freq].value = HCI_state[Custom_Woofer_Freq].default_value;
  HCI_state[Custom_Woofer_Freq].value_table_pointer = &Custom_woofer_freq_values[0][0];
  HCI_state[Custom_Woofer_Freq].number_of_values = Custom_woofer_freq_qty;
  HCI_state[Custom_Woofer_Freq].value_length = Custom_woofer_freq_len;

  HCI_state[Custom_Woofer_Q].default_value = 2;     //default Q = .7
  HCI_state[Custom_Woofer_Q].value = HCI_state[Custom_Tweeter_Q].default_value;
  HCI_state[Custom_Woofer_Q].value_table_pointer = &Bass_filters_Q_values[0][0];       //use Bass Filters Q table
  HCI_state[Custom_Woofer_Q].number_of_values = Bass_filters_Q_qty;
  HCI_state[Custom_Woofer_Q].value_length = Bass_filters_Q_len;

  HCI_state[Custom_Woofer_Gain].default_value = 13;     //default gain = 0
  HCI_state[Custom_Woofer_Gain].value = HCI_state[Custom_Woofer_Gain].default_value;
  HCI_state[Custom_Woofer_Gain].value_table_pointer = &Custom_gain_values[0][0];
  HCI_state[Custom_Woofer_Gain].number_of_values = Custom_gain_qty;
  HCI_state[Custom_Woofer_Gain].value_length = Custom_gain_len;

  HCI_state[Custom_Sub_Type].default_value = 10;     //default filter = none
  HCI_state[Custom_Sub_Type].value = HCI_state[Custom_Sub_Type].default_value;
  HCI_state[Custom_Sub_Type].value_table_pointer = &Custom_type_values[0][0];
  HCI_state[Custom_Sub_Type].number_of_values = Custom_type_qty;
  HCI_state[Custom_Sub_Type].value_length = Custom_type_len;

  HCI_state[Custom_Sub_Freq].default_value = 10;     //default freq
  HCI_state[Custom_Sub_Freq].value = HCI_state[Custom_Sub_Freq].default_value;
  HCI_state[Custom_Sub_Freq].value_table_pointer = &Custom_woofer_freq_values[0][0];
  HCI_state[Custom_Sub_Freq].number_of_values = Custom_woofer_freq_qty;
  HCI_state[Custom_Sub_Freq].value_length = Custom_woofer_freq_len;

  HCI_state[Custom_Sub_Q].default_value = 2;     //default Q = .7
  HCI_state[Custom_Sub_Q].value = HCI_state[Custom_Sub_Q].default_value;
  HCI_state[Custom_Sub_Q].value_table_pointer = &Bass_filters_Q_values[0][0];       //use Bass Filters Q table
  HCI_state[Custom_Sub_Q].number_of_values = Bass_filters_Q_qty;
  HCI_state[Custom_Sub_Q].value_length = Bass_filters_Q_len;

  HCI_state[Custom_Sub_Gain].default_value = 13;     //default gain = 0
  HCI_state[Custom_Sub_Gain].value = HCI_state[Custom_Sub_Gain].default_value;
  HCI_state[Custom_Sub_Gain].value_table_pointer = &Custom_gain_values[0][0];
  HCI_state[Custom_Sub_Gain].number_of_values = Custom_gain_qty;
  HCI_state[Custom_Sub_Gain].value_length = Custom_gain_len;


  HCI_state[Curvature].default_value = 5;     //default curvature = 5
  HCI_state[Curvature].value = HCI_state[Curvature].default_value;
  HCI_state[Curvature].value_table_pointer = &Curvature_values[0][0];
  HCI_state[Curvature].number_of_values = Curvature_qty;
  HCI_state[Curvature].value_length = Curvature_len;

  HCI_state[Shading].default_value = 5;     //default curvature = 5
  HCI_state[Shading].value = HCI_state[Shading].default_value;
  HCI_state[Shading].value_table_pointer = &Shading_values[0][0];
  HCI_state[Shading].number_of_values = Shading_qty;
  HCI_state[Shading].value_length = Shading_len;

  HCI_state[Speaker_select].default_value = 0;     //default speakers = All on
  HCI_state[Speaker_select].value = HCI_state[Speaker_select].default_value;
  HCI_state[Speaker_select].value_table_pointer = &Speaker_select_values[0][0];
  HCI_state[Speaker_select].number_of_values = Speaker_select_qty;
  HCI_state[Speaker_select].value_length = Speaker_select_len;

  current_field_ID = 0;
}


void previous_value() {
  if (HCI_state[current_field_ID].value > 0 ) {
    HCI_state[current_field_ID].value--;
  }
  else  {
    HCI_state[current_field_ID].value = HCI_state[current_field_ID].number_of_values - 1;
  }
  update_from_HCI(current_field_ID, HCI_state[current_field_ID].value) ;
}

void next_value() {

  if (HCI_state[current_field_ID].value < (HCI_state[current_field_ID].number_of_values - 1) ) {
    HCI_state[current_field_ID].value++;
  }
  else  {
    HCI_state[current_field_ID].value = 0;
  } 
  update_from_HCI(current_field_ID, HCI_state[current_field_ID].value);
}


void current_value(byte field_ID, byte value, bool update_display) {

  if (value == 255) {
    //0xFF is the code for the next value
    next_value();
  }
  else if (value == 254) {
    //0xFE is for the previous value
    previous_value();
  }
  else if (value == 253) {
    //if 0xFD, reload the existing value
    //don't do anything -- just let the response get published
  }
  else if (value < 253) {
    //If not one of those special values, update the field value
    HCI_state[field_ID].value = value;
    update_from_HCI(field_ID, HCI_state[current_field_ID].value);    
  }
  get_field_string(field_ID);

  send_ID_and_value_to_SPDIF(field_ID, HCI_state[current_field_ID].value);
  tx_timer = millis() + TX_revisit_time;  //set timer to send out the zero command from the main loop
}


void get_field_string(byte ID) {
  long i;
  char field_string[17];
  long table_offset;
  //byte value = HCI_state[ID].value;
  long len = HCI_state[ID].value_length;

  table_offset = HCI_state[ID].value * (len + 1);

  for (i = 0; i < len; i++) {
    field_string[i] = pgm_read_byte_far(HCI_state[ID].value_table_pointer + i + table_offset);
    field_string_global[i] = field_string[i];
  }
  field_string[i] = '\0';
  field_string_global[i] = '\0';
}
