readi/*-----------------------------------------------------------------------------------------
   Tables and enumerations used to define the HCI
  ----------------------------------------------------------------------------------------*/

/* These strings are the responses to commands, and they are the displayed values for the LCD 
  or cell phone display.  They are stored in program space using PROGMEM so they don't waste RAM */

const byte vol_value_qty = 87;
const byte vol_value_len = 3;
const char vol_values[vol_value_qty][vol_value_len + 1] PROGMEM = {
  {"-80"}, {"-79"}, {"-78"}, {"-77"}, {"-76"}, {"-75"}, {"-74"}, {"-73"}, {"-72"}, {"-71"},
  {"-70"}, {"-69"}, {"-68"}, {"-67"}, {"-66"}, {"-65"}, {"-64"}, {"-63"}, {"-62"}, {"-61"},
  {"-60"}, {"-59"}, {"-58"}, {"-57"}, {"-56"}, {"-55"}, {"-54"}, {"-53"}, {"-52"}, {"-51"},
  {"-50"}, {"-49"}, {"-48"}, {"-47"}, {"-46"}, {"-45"}, {"-44"}, {"-43"}, {"-42"}, {"-41"},
  {"-40"}, {"-39"}, {"-38"}, {"-37"}, {"-36"}, {"-35"}, {"-34"}, {"-33"}, {"-32"}, {"-31"},
  {"-30"}, {"-29"}, {"-28"}, {"-27"}, {"-26"}, {"-25"}, {"-24"}, {"-23"}, {"-22"}, {"-21"},
  {"-20"}, {"-19"}, {"-18"}, {"-17"}, {"-16"}, {"-15"}, {"-14"}, {"-13"}, {"-12"}, {"-11"},
  {"-10"}, {"-9 "}, {"-8 "}, {"-7 "}, {"-6 "}, {"-5 "}, {"-4 "}, {"-3 "}, {"-2 "}, {"-1 "},
  {" 0 "}, {"+1 "}, {"+2 "}, {"+3 "}, {"+4 "}, {"+5 "}, {"+6 "}
};

const byte mute_value_qty = 2;
const byte mute_value_len = 8;
const char mute_values[mute_value_qty][mute_value_len + 1] PROGMEM = {
  {"Mute Off"}, {" Muted  "}
};

const byte input_value_qty = 4;
const byte input_value_len = 6;
const char input_values[input_value_qty][input_value_len + 1] PROGMEM = {
  {"Analog"}, {" WiFi "}, {"  PC  "}, {" Test "}
};

//Note:  the string lengths are increased by 1 in the array declarations to allow space for the null

const byte chan_trim_qty = 11;
const byte chan_trim_len = 3;
const char chan_trim_values[chan_trim_qty][chan_trim_len + 1] PROGMEM = {
  {"-10"}, {"-9 "}, {"-8 "}, {"-7 "}, {"-6 "}, {"-5 "}, {"-4 "}, {"-3 "}, {"-2 "}, {"-1 "}, {" 0 "}
};


const byte delay_values_qty = 12;
const byte delay_values_len = 4;
const char delay_values[delay_values_qty][delay_values_len + 1] PROGMEM = {{"0.0 "}, {"0.28"}, {"0.56"}, {"0.84"},
  {"1.13"}, {"1.41"}, {"1.69"}, {"2.25"}, {"2.81"}, {"3.66"}, {"4.78"}, {"5.91"}
};

const byte BSC_freq_qty = 8;
const byte BSC_freq_len = 6;
const char BSC_freq_values[BSC_freq_qty][BSC_freq_len + 1] PROGMEM = {{" 300Hz"}, {" 400Hz"}, {" 500Hz"}, {" 600Hz"}, {" 700Hz"}, {" 800Hz"}, {" 900Hz"}, {"1.0KHz"}};

const byte BSC_gain_qty = 7;
const byte BSC_gain_len = 3;
const char BSC_gain_values[BSC_gain_qty][BSC_gain_len + 1] PROGMEM = {{"0dB"}, {"1dB"}, {"2dB"}, {"3dB"}, {"4dB"}, {"5dB"}, {"6dB"}};

const byte Xover_T_W_type_qty = 6;
const byte Xover_T_W_type_len = 5;
const char Xover_T_W_type_values[Xover_T_W_type_qty][Xover_T_W_type_len + 1] PROGMEM = {{"None "}, {"B-W 1"}, {"B-W 3"}, {"L-R 2"}, {"L-R 4"}, {"L-R 8"}};
const byte Xover_T_W_freq_qty = 7;
const byte Xover_T_W_freq_len = 4;
const char Xover_T_W_freq_values[Xover_T_W_freq_qty][Xover_T_W_freq_len + 1] PROGMEM = {{"1000"}, {"1500"}, {"2000"}, {"2500"}, {"3000"}, {"3500"}, {"4000"}};
const byte Xover_T_W_polarity_qty = 2;
const byte Xover_T_W_polarity_len = 2;
const char Xover_T_W_polarity_values[Xover_T_W_polarity_qty][Xover_T_W_polarity_len + 1] PROGMEM = {{"M+"}, {"M-"}};

const byte Xover_W_S_type_qty = 5;
const byte Xover_W_S_type_len = 5;
const char Xover_W_S_type_values[Xover_W_S_type_qty][Xover_W_S_type_len + 1] PROGMEM = {{"None "}, {"B-W 1"}, {"B-W 3"}, {"L-R 2"}, {"L-R 4"}};
const byte Xover_W_S_freq_qty = 6;
const byte Xover_W_S_freq_len = 3;
const char Xover_W_S_freq_values[Xover_W_S_freq_qty][Xover_W_S_freq_len + 1] PROGMEM = {{" 80"}, {"100"}, {"120"}, {"150"}, {"200"}, {"300"}};
const byte Xover_W_S_polarity_qty = 2;
const byte Xover_W_S_polarity_len = 2;
const char Xover_W_S_polarity_values[Xover_W_S_polarity_qty][Xover_W_S_polarity_len + 1] PROGMEM = {{"S+"}, {"S-"}};

const byte EQ_freq_qty = 10;
const byte EQ_freq_len = 7;
const char EQ_freq_values[EQ_freq_qty][EQ_freq_len + 1] PROGMEM = {{"   32Hz"}, {"   64Hz"}, {"  125Hz"}, {"  250Hz"}, {"  500Hz"}, {" 1000Hz"}, {" 2000Hz"}, {" 4000Hz"}, {" 8000Hz"}, {"16000Hz"}};

const byte EQ_gain_qty = 11;
const byte EQ_gain_len = 5;
const char EQ_gain_values[EQ_gain_qty][EQ_gain_len + 1] PROGMEM = {{"-10dB"}, {" -8dB"}, {" -6dB"}, {" -4dB"}, {" -2dB"}, {"  0dB"}, {" +2dB"}, {" +4dB"}, {" +6dB"}, {" +8dB"}, {"+10dB"}};

float EQ_gain_array[EQ_freq_qty] = {32.0, 64.0, 125.0, 250.0, 500.0, 1000.0, 2000.0, 4000.0, 8000.0, 16000.0};
byte EQ_gain_settings[EQ_freq_qty] = {5, 5, 5, 5, 5, 5, 5, 5, 5};

const byte Bass_filters_freq_qty = 9;
const byte Bass_filters_freq_len = 3;
const char Bass_filters_freq_values[Bass_filters_freq_qty][Bass_filters_freq_len + 1] PROGMEM = {{" 15"}, {" 20"}, {" 30"}, {" 40"}, {" 50"}, {" 65"}, {" 80"}, {"100"}, {"120"}};

const byte Bass_filters_Q_qty = 6;
const byte Bass_filters_Q_len = 3;
const char Bass_filters_Q_values[Bass_filters_Q_qty][Bass_filters_Q_len + 1] PROGMEM = {{"0.5"}, {"0.7"}, {"1.0"}, {"1.5"}, {"2.2"}, {"2.9"}};

const byte Bass_filters_Gain_qty = 6;
const byte Bass_filters_Gain_len = 3;
const char Bass_filters_Gain_values[Bass_filters_Gain_qty][Bass_filters_Gain_len + 1] PROGMEM = {{"1.0"}, {"2.0"}, {"3.0"}, {"4.0"}, {"5.0"}, {"6.0"}};


const byte Bass_Enhancement_Mode_qty = 5;
const byte Bass_Enhancement_Mode_len = 9;
const char Bass_Enhancement_Mode_values[Bass_Enhancement_Mode_qty][Bass_Enhancement_Mode_len + 1] PROGMEM = {{"Rumb On  "}, {"Peak On  "}, {"Rumb_Peak"}, {"SB   On  "}, {" Off     "}
};


const byte DB_Threshold_qty = 13;
const byte DB_Threshold_len = 3;
const char DB_Threshold_values[DB_Threshold_qty][DB_Threshold_len + 1] PROGMEM = {{"-24"}, {"-21"}, {"-18"}, {"-15"}, {"-12"}, {"-9 "}, {"-6 "}, {"-3 "}, {" 0 "}, {" +5"}, {"+10"}, {"+15"}, {"+20"}};

const byte DB_Time_constant_qty = 9;
const byte DB_Time_constant_len = 3;
const char DB_Time_constant_values[DB_Time_constant_qty][DB_Time_constant_len + 1] PROGMEM = {{" 0 "}, {" 50"}, {"100"}, {"150"}, {"200"}, {"250"}, {"300"}, {"400"}, {"500"}};

const byte DB_Bass_Boost_qty = 8;
const byte DB_Bass_Boost_len = 3;
const char DB_Bass_Boost_values[DB_Bass_Boost_qty][DB_Bass_Boost_len + 1] PROGMEM = {{" 0 "}, {" 3 "}, {" 6 "}, {" 9 "}, {"12 "}, {"15 "}, {"18 "}, {"20 "}};

//Note:  use same frequency table for Bass Frequency as SuperBass

const byte ADAU1466_Source_qty = 5;
const byte ADAU1466_Source_len = 5;
const char ADAU1466_Source_values[ADAU1466_Source_qty][ADAU1466_Source_len + 1] PROGMEM = {{"Sine "}, {"Sweep"}, {"White"}, {" VCO "}, {"Mute "}};

const byte ADAU1466_Freq_qty = 10;
const byte ADAU1466_Freq_len = 3;
const char ADAU1466_Freq_values[ADAU1466_Freq_qty][ADAU1466_Freq_len + 1] PROGMEM = {{" 32"}, {" 64"}, {"125"}, {"250"}, {"500"},{" 1K"}, {" 2K"}, {" 4K"}, {" 8K"}, {"16K"}};

const byte ADAU1466_Range_qty = 4;
const byte ADAU1466_Range_len = 8;
const char ADAU1466_Range_values[ADAU1466_Range_qty][ADAU1466_Range_len + 1] PROGMEM = {{"20 - 20K"}, {"10 - 1K "}, {"300 - 5K"}, {"1K - 20K"}};

const byte ADAU1466_Steps_qty = 4;
const byte ADAU1466_Steps_len = 4;
const char ADAU1466_Steps_values[ADAU1466_Steps_qty][ADAU1466_Steps_len + 1] PROGMEM = {{" 10 "}, {" 100"}, {" 250"}, {" 500"}};

const byte ADAU1466_Speed_qty = 4;
const byte ADAU1466_Speed_len = 5;
const char ADAU1466_Speed_values[ADAU1466_Speed_qty][ADAU1466_Speed_len + 1] PROGMEM = {{"400ms"}, {"200ms"}, {" 80ms"}, {" 40ms"}};

const byte Custom_filter_select_qty = 5;
const byte Custom_filter_select_len = 8;
const char Custom_filter_select_values[Custom_filter_select_qty][Custom_filter_select_len + 1] PROGMEM = {{"Shared_1"}, {"Shared_2"}, {" Tweeter"}, {" Woofer "}, {"   Sub  "}};

const byte Custom_type_qty = 11;
const byte Custom_type_len = 9;
const char Custom_type_values[Custom_type_qty][Custom_type_len + 1] PROGMEM = {{"1_Pole_LP"}, {"1_Pole_HP"}, {"2_Pole_LP"}, {"2_Pole_HP"}, {"LP_Shelf "}, {"HP_Shelf "},
  {"Bandpass "}, {"  Notch  "}, {" Peaking "}, {"All_Pass "}, {"   None  "}
};

const byte Custom_gain_qty = 25;
const byte Custom_gain_len = 4;
const char Custom_gain_values[Custom_gain_qty][Custom_gain_len + 1] PROGMEM = {{" -10"}, {"  -8"}, {"  -6"}, {"  -5"}, {"  -4"}, {"  -3"}, {"  -2"}, {"-1.5"}, {"-1.2"}, {"  -1"},
  {"-0.5"}, {"-0.2"}, {"  0 "}, {"+0.2"}, {"+0.5"}, {"  +1"}, {"+1.2"}, {"+1.5"}, {"  +2"}, {"  +3"}, {"  +4"}, {"  +5"}, {"  +6"}, {"  +8"}, {" +10"}
};

const byte Custom_freq_qty = 87;
const byte Custom_freq_len = 4;
const char Custom_freq_values[Custom_freq_qty][Custom_freq_len + 1] PROGMEM = {
  {"  30"}, {"  32"}, {"  34"}, {"  36"}, {"  38"}, {"  40"}, {"  42"}, {"  45"}, {"  48"}, {"  51"},
  {"  54"}, {"  57"}, {"  60"}, {"  64"}, {"  68"}, {"  72"}, {"  76"}, {"  80"}, {"  85"}, {"  90"},
  {"  95"}, {" 100"}, {" 110"}, {" 120"}, {" 130"}, {" 140"}, {" 150"}, {" 160"}, {" 170"}, {" 180"},
  {" 190"}, {" 200"}, {" 215"}, {" 230"}, {" 245"}, {" 260"}, {" 280"}, {" 300"}, {" 325"}, {" 350"},
  {" 375"}, {" 400"}, {" 430"}, {" 465"}, {" 500"}, {" 540"}, {" 580"}, {" 630"}, {" 680"}, {" 730"},
  {" 780"}, {" 830"}, {" 880"}, {" 940"}, {"1000"}, {"1070"}, {"1140"}, {"1220"}, {"1300"}, {"1400"},
  {"1500"}, {"1610"}, {"1720"}, {"1850"}, {"2000"}, {"2150"}, {"2320"}, {"2500"}, {"2700"}, {"2900"},
  {"3100"}, {"3300"}, {"3500"}, {"3750"}, {"4000"}, {"4300"}, {"4600"}, {"4900"}, {"5300"}, {"5700"},
  {"6100"}, {"6500"}, {"7000"}, {"7500"}, {"8000"}, {"8500"}, {"9000"}
};

const byte Custom_tweeter_freq_qty = 43;
const byte Custom_tweeter_freq_len = 4;
const char Custom_tweeter_freq_values[Custom_tweeter_freq_qty][Custom_tweeter_freq_len + 1] PROGMEM = {
  {" 500"}, {" 540"}, {" 580"}, {" 630"}, {" 680"}, {" 730"},
  {" 780"}, {" 830"}, {" 880"}, {" 940"}, {"1000"}, {"1070"}, {"1140"}, {"1220"}, {"1300"}, {"1400"},
  {"1500"}, {"1610"}, {"1720"}, {"1850"}, {"2000"}, {"2150"}, {"2320"}, {"2500"}, {"2700"}, {"2900"},
  {"3100"}, {"3300"}, {"3500"}, {"3750"}, {"4000"}, {"4300"}, {"4600"}, {"4900"}, {"5300"}, {"5700"},
  {"6100"}, {"6500"}, {"7000"}, {"7500"}, {"8000"}, {"8500"}, {"9000"}
};

const byte Custom_woofer_freq_qty = 45;
const byte Custom_woofer_freq_len = 4;
const char Custom_woofer_freq_values[Custom_woofer_freq_qty][Custom_woofer_freq_len + 1] PROGMEM = {
  {" 30 "}, {" 32 "}, {" 34 "}, {" 36 "}, {" 38 "}, {" 40 "}, {" 42 "}, {" 45 "}, {" 48 "}, {" 51 "},
  {" 54 "}, {" 57 "}, {" 60 "}, {" 64 "}, {" 68 "}, {" 72 "}, {" 76 "}, {" 80 "}, {" 85 "}, {" 90 "},
  {" 95 "}, {" 100"}, {" 110"}, {" 120"}, {" 130"}, {" 140"}, {" 150"}, {" 160"}, {" 170"}, {" 180"},
  {" 190"}, {" 200"}, {" 215"}, {" 230"}, {" 245"}, {" 260"}, {" 280"}, {" 300"}, {" 325"}, {" 350"},
  {" 375"}, {" 400"}, {" 430"}, {" 465"}, {" 500"}
};

const byte Mono_sub_value_qty = 2;
const byte Mono_sub_value_len = 6;
const char Mono_sub_values[Mono_sub_value_qty][Mono_sub_value_len + 1] PROGMEM = {
  {"Stereo"}, {" Mono "}
};

const byte Curvature_qty = 9;
const byte Curvature_len = 2;
const char Curvature_values[Curvature_qty][Curvature_len + 1] PROGMEM = {{"-4"}, {"-3"}, {"-2"}, {"-1"}, {"0 "}, {"+1"}, {"+2"}, {"+3"}, {"+4"}};

const byte Shading_qty = 9;
const byte Shading_len = 2;
const char Shading_values[Shading_qty][Shading_len + 1] PROGMEM = {{"-4"}, {"-3"}, {"-2"}, {"-1"}, {"0 "}, {"+1"}, {"+2"}, {"+3"}, {"+4"}};

const byte Speaker_select_qty = 23;
const byte Speaker_select_len = 2;
const char Speaker_select_values[Speaker_select_qty][Speaker_select_len + 1] PROGMEM = {
  {"00"}, {"01"}, {"02"}, {"03"}, {"04"}, {"05"}, {"06"}, {"07"}, {"08"}, {"09"}, {"10"}, {"11"},
  {"12"}, {"13"}, {"14"}, {"15"}, {"16"}, {"17"}, {"18"}, {"19"}, {"20"}, {"21"}, {"22"}
};
