/* This module is for application-specific initialization of the CPU ports and other registers that aren't typically changed
   It also intitializes the hardware for other "external" devices such as Bluetooth modules, external DAC's, ASRC's or ADC's
   For simple designs with just the ESP32 and ADAU1466, there is no need for any code here.  In those cases, the code here is
   "left over" from some other design and isn't called.
*/

void Port_init() {
  //initialize ports

  /*
  pinMode(led, OUTPUT);
  digitalWrite(led, HIGH);  //Let there be light

  pinMode(WP, OUTPUT);
  digitalWrite(WP, HIGH);  //write protect is on
                           /*
  pinMode(ADAU1466_reset, OUTPUT);
  digitalWrite(ADAU1466_reset, LOW);  //JAB4 reset is low
*/

  pinMode(ADAU1466_reset, OUTPUT_OPEN_DRAIN);    //Make reset line an output
  digitalWrite(ADAU1466_reset, HIGH);  //Start out with reset high
  delay(1);
  digitalWrite(ADAU1466_reset, LOW);  //The ADAU1466 is active low reset
  delay(300);
  //pinMode(ADAU1466_reset, INPUT_PULLUP);     //Make an input to remove the reset
  digitalWrite(ADAU1466_reset, HIGH);  //raise the pin to remove the reset signal
  delay(300);                          //give the ADAU1466 at least 300ms to reset


  pinMode(SPDIF_sel, OUTPUT);     //Make SPDIF mux line an output
  digitalWrite(SPDIF_sel, HIGH);  //put a "1" in the output latch
  delay(100);
}


void SPI_port_init() {
  //pull SS low three times to force ADAU1466 slave interface into SPI mode

  digitalWrite(SPI_SS, HIGH);  //initialize SS
  pinMode(SPI_SS, OUTPUT);
  delay(1);

  digitalWrite(SPI_SS, LOW);  //pull SS low
  delay(1);
  digitalWrite(SPI_SS, HIGH);  //turn off SS
  delay(1);
  digitalWrite(SPI_SS, LOW);  //pull SS low
  delay(1);
  digitalWrite(SPI_SS, HIGH);  //turn off SS
  delay(1);
  digitalWrite(SPI_SS, LOW);  //pull SS low
  delay(1);
  digitalWrite(SPI_SS, HIGH);  //turn off SS
  delay(1);
}

void BLE_Init() {
  /*  See guide at: https://github.com/nkolban/esp32-snippets/tree/master/Documentation
  https://github.com/nkolban/esp32-snippets/blob/master/cpp_utils/tests/BLETests/Arduino/security/BLE_server/BLE_server_numeric_confirmation/BLE_server_numeric_confirmation.ino#L63-L67
  https://github.com/espressif/esp-idf/blob/3c94b6e10a471223616564bfc9b9c88232e749e6/examples/bluetooth/gatt_security_server/main/example_ble_sec_gatts_demo.c#L555-L575
  */

  // Initialize the BLE environment
  BLEDevice::init("Line_Array_2L");
  //BLEDevice::init("Cherry_sub");

  // Create the BLE Server
  BLEServer *pServer = BLEDevice::createServer();
  pServer->setCallbacks(new MyServerCallbacks());

  // Create the BLE Service
  BLEService *pService = pServer->createService(SERVICE_UUID);

  // Create a BLE Characteristic
  pCharacteristic = pService->createCharacteristic(
    CHARACTERISTIC_UUID_TX,
    BLECharacteristic::PROPERTY_NOTIFY);

  pCharacteristic->addDescriptor(new BLE2902());

  BLECharacteristic *pCharacteristic = pService->createCharacteristic(
    CHARACTERISTIC_UUID_RX,
    BLECharacteristic::PROPERTY_WRITE);

  pCharacteristic->setCallbacks(new MyCallbacks());

  // Start the service
  pService->start();


  BLESecurity *pSecurity = new BLESecurity();
  pSecurity->setKeySize();
  pSecurity->setAuthenticationMode(ESP_LE_AUTH_REQ_SC_ONLY);
  pSecurity->setStaticPIN(123456);
  pSecurity->setCapability(ESP_IO_CAP_NONE);
  pSecurity->setInitEncryptionKey(ESP_BLE_ENC_KEY_MASK | ESP_BLE_ID_KEY_MASK);

  // Start advertising
  pServer->getAdvertising()->addServiceUUID(pService->getUUID());
  pServer->getAdvertising()->start();
  Serial.println("Waiting for a client connection to notify...");
}

void reset_JAB4() {
  //digitalWrite(ADAU1466_reset, HIGH);  //JAB4 reset is asserted
  //delay(300);                          //wait at least 260ms for ADAU1466 to re-initialize
  //digitalWrite(ADAU1466_reset, LOW);   //JAB4 reset is off
}
