/*
  ADAU1466_cmd - Library for executing the ADAU1466 commands for the Audiodeveloper DSP boards.
  Created by Neil Davis, December, 2020.
*/

#ifndef ADAU1466_cmd_H
#define ADAU1466_cmd_H

#include "Arduino.h"
#include "ADAU1466_DSP.h"
#define number_of_mute_addresses 3
#define number_of_channels 3

/*struct BQ_spec {
  byte biquads_needed;
  float Freq_center;
  byte filter_order[7];
  float filter_q[7];
  };*/

class ADAU1466_cmd {
public:
  ADAU1466_cmd(word ADAU1466_Mute_addresses[number_of_mute_addresses]);


  //enum Xover_drivers {ST_T, T_M, M_W, W_S};

  void Main_Volume(int reg_num, int value_code);
  void Mute(int reg_num, int value_code);
  void Input_select(int reg_num, int value_code);
  void Chan_vol_trim(int reg_num, int value_code);
  void Update_Delay(int reg_num, int value_code);
  void T_W_Xover(byte freq_code, byte Xover_type_code, word biquad_addresses[5][2]);
  void W_S_Xover(byte freq_code, byte Xover_type_code, word biquad_addresses[4][2]);
  void Mute_all(word mute_addresses[number_of_mute_addresses], int mute_state);

  void BSC_Freq_or_Gain(int reg_num, int freq_code, int gain_code);

  void Xover_T_polarity(int T_Pol_Addr, int value_code);
  void Xover_W_polarity(int W_Pol_Addr, int value_code);
  void Xover_S_polarity(int S_Pol_Addr, int value_code);

  void EQ_Filter(int reg_num, float Freq, int value_code);

  void Rumble_filter(word Rumble_filter_address, int freq_code, int Q_code, bool Rumble_enabled);
  void Peak_filter(word Peak_filter_address, int freq_code, int Gain_code, bool Peak_enabled);

  void Custom_filter(int reg_num, Shared_enum::tfilters filter_type, float filter_freq, float filter_gain, float filter_Q);
  //void Custom_filter_stereo(int Filter_Addr, Shared_enum::tfilters filter_type, float filter_freq, float filter_gain, float filter_Q);
  //alternate custom filter functions that pass the HCI index rather than those floating point values
  //void Custom_filter_index(int reg_num, int filter_type_code, int filter_freq_code, int filter_gain_code, int filter_Q_code);
  //void Custom_filter_stereo_index(word Filter_Addr[2], int filter_type_code, int filter_freq_code, int filter_gain_code, int filter_Q_code);

  
  void ADAU1466_Source_select(int regnum, byte source_code, byte sweep_reg);
  void ADAU1466_Sine(int regnum, byte freq_code);
  void ADAU1466_Sweep(int regnum, byte range_code, byte steps_code, byte speed_code);

  void Curvature_select(int curvature, word tweeter_delay_addresses[12], word woofer_delay_addresses[7]);
  void Shading_select(int vol_taper, word tweeter_shading_addresses[12], word woofer_shading_addresses[7]);
  void Speaker_select(int speaker_code, word ADAU1466_Mute_addresses[3], word tweeter_mute_addresses[12], word woofer_mute_addresses[7] );

/*  Private routines used to support the ADAU1466_cmd commands */
private:
  word _copy_of_Mute_addresses[number_of_mute_addresses];
  uint8_t _I2C_addr;
  void convert_Vol_to_8_24(const byte* Vol_table, byte v);  //use current HCI value and volume look-up table to convert to ADAU1466 format
  void float_to_safeload(int reg_num, float f);
  void uint32_to_safeload(int reg_num, uint32_t i);
  void Set_Vol_Trim_to_0(word reg_number);                  //put a 5-byte zero into the specified Parameter RAM register
  void convert_delay_level(byte delay_level);
  void Set_Mute_to_0(word reg_number);
  void Set_Mute_to_1(word reg_number);
  void Set_invert_to_on(word reg_number);
  void Set_invert_to_off(word reg_number);
  void Mute();  //shorter version of Mute_all
  void Unmute();
  float Convert_BSC_freq_code(int freq_code);
  float Convert_BSC_gain_code(int gain_code);
  float Convert_EQ_gain_code(int gain_code);
  void update_driver_delay(word driver_delay_address, byte delay_data);
};

#endif
