/*
  Shared Enumerations - Library for defining the common enumerations used in multiple libraries
  Created by Neil Davis, January, 2021.
*/

#ifndef Shared_enum_H
#define Shared_enum_H

#include "Arduino.h"

class Shared_enum
{

  public:
    Shared_enum();

    enum tfilters {One_Pole_LP, One_Pole_HP, Two_Pole_LP, Two_Pole_HP, LP_Shelf, HP_Shelf, Bandpass, Notch, Peaking, All_Pass, None};

    struct BQ_spec {
  	byte biquads_needed;
  	float Freq_center;
  	byte filter_order[7];
  	float filter_q[7];
    };

    enum Xovers {none, BW_1, BW_3, LR_2, LR_4, LR_8, BW_2, BW_4, BW_5, BW_6, Bes_2, Bes_3, Bes_4, Bes_5, Bes_6, LR_6, LR_10, LR_12, LR_14};

    enum Xover_drivers {ST_T, T_M, M_W, W_S, T_W};


    struct Filter_spec {
	  tfilters filter_type;
  	float Freq_center;
  	float Q;
  	float Gain;
    };
};

#endif
