/*
  ADAU1466_I2C - Library for communicating with the ADAU1466.
  The ADAU1466 uses 16-bit addressing, so the simple wire instructions aren't adequate.  These routines
     provide the 16-bit addressing.

     These routines use the Wire library, which must be initialized separately.

  Created by Neil Davis, March, 2023.
*/

#ifndef ADAU1466_SPI_H
#define ADAU1466_SPI_H

#include "Arduino.h"
#include <SPI.h>

class ADAU1466_SPI
{
public:
  ADAU1466_SPI(word Safeload_addr, int8_t sck, int8_t miso, int8_t mosi, int8_t cspin, SPIClass *theSPI = &SPI);

  // void Read_block(byte MSB, byte LSB, uint8_t (&Data_block)[16], int count);
  void begin(void);
  void SPI_write_Mult(uint8_t addr_MSB, uint8_t addr_LSB, uint8_t count, uint8_t command_buffer[]);
  uint16_t SPI_read_reg(uint8_t addr_MSB, uint8_t addr_LSB);
  void SPI_write_reg_string(uint8_t addr_MSB, uint8_t addr_LSB, String command_string);
  void SPI_write_reg_int(uint8_t addr_MSB, uint8_t addr_LSB,  uint8_t value);
  void safeload_addr(word reg_num);
  void safeload_data(uint8_t safeload_data_array[]);
  void biquad_safe_load(word filter_reg, byte ADAU1466_coefs[5][4]);
  void safeload_xfer(uint8_t count);

private:
  // these are values that need to get set and stay set after initialization, since they get used later
  word _Safeload_addr;
  int8_t _cs, _sck, _mosi, _miso;
  SPIClass *_spi = nullptr;
};

#endif
