#include "Arduino.h"
#include "ADAU1466_SPI.h"

ADAU1466_SPI::ADAU1466_SPI(word Safeload_addr, int8_t SPI_SCK, int8_t SPI_MISO, int8_t SPI_MOSI, int8_t SPI_SS, SPIClass *theSPI)
{
  _Safeload_addr = Safeload_addr;
  _sck = SPI_SCK;
  _miso = SPI_MISO;
  _mosi = SPI_MOSI;
  _cs = SPI_SS;
  _spi = theSPI;
}

void ADAU1466_SPI::begin(void)
{
  _spi->begin(_sck, _miso, _mosi, _cs);
}

void ADAU1466_SPI::SPI_write_Mult(uint8_t addr_MSB, uint8_t addr_LSB, uint8_t count, uint8_t command_buffer[])
{
  uint8_t buf[10];
  buf[0] = 0; // SPI address = 0 for ADAU1466
  buf[1] = addr_MSB;
  buf[2] = addr_LSB;
  for (uint8_t x = 0; x < count; x++)
  {
    buf[x + 3] = command_buffer[x]; // copy data into buffer
  }

  /*
  Serial.print(_sck);
  Serial.print("  ");
  Serial.print(_mosi);
  Serial.print("  ");
  Serial.println(_cs);
  */
  _spi->beginTransaction(SPISettings(10000000, MSBFIRST, SPI_MODE3));
  digitalWrite(_cs, LOW); // pull SS slow to prep other end for transfer
  for (int i = 0; i < count + 3; i++)
  {
    _spi->transfer(buf[i]);
    // Serial.print(buf[i]);
    // Serial.print(" ");
  }
  // Serial.println(" ");

  digitalWrite(_cs, HIGH); // pull SS high to signify end of data transfer
  _spi->endTransaction();
 
 /* Serial.print("SPI_write to ");
  Serial.print(addr_MSB, HEX);
  Serial.println(addr_LSB, HEX);
  */
}

uint16_t ADAU1466_SPI::SPI_read_reg(uint8_t addr_MSB, uint8_t addr_LSB)
{
  uint8_t buf[4];
  uint8_t dummy_read;
  uint16_t reg_val;

  buf[0] = 1; // SPI address = 01 for ADAU1466 read
  buf[1] = addr_MSB;
  buf[2] = addr_LSB;

  _spi->beginTransaction(SPISettings(10000000, MSBFIRST, SPI_MODE3));
  digitalWrite(_cs, LOW); // pull SS slow to prep other end for transfer

  for (int i = 0; i < 3; i++)
  {
    dummy_read = _spi->transfer(buf[i]); // output chip address, R/W, and register address
  }
  
  reg_val = _spi->transfer16(0); // 0 is a dummy
  //reg_val = (uint16_t)MISO_data;
  //MISO_data = _spi->transfer(1); // 1 is a dummy
  //reg_val = reg_val | (uint16_t)junk << 8;

  //Serial.print("Read from ADAU1467:  ");
  //Serial.println(reg_val, HEX);

  digitalWrite(_cs, HIGH); // pull SS high to signify end of data transfer
  _spi->endTransaction();
  return reg_val;
}

void ADAU1466_SPI::SPI_write_reg_int(uint8_t addr_MSB, uint8_t addr_LSB,  uint8_t value)
{
  uint8_t buf[10];
  uint16_t reg_val;

  buf[0] = 0; // SPI address = 0 for ADAU1466 write
  buf[1] = addr_MSB;
  buf[2] = addr_LSB;

  _spi->beginTransaction(SPISettings(10000000, MSBFIRST, SPI_MODE3));
  digitalWrite(_cs, LOW); // pull SS slow to prep other end for transfer

  for (int i = 0; i < 3; i++)
  {
    _spi->transfer(buf[i]); // output chip address, R/W, and register address
  }
  
  _spi->transfer16((uint16_t)value);
    
  digitalWrite(_cs, HIGH); // pull SS high to signify end of data transfer
  _spi->endTransaction();
}

void ADAU1466_SPI::SPI_write_reg_string(uint8_t addr_MSB, uint8_t addr_LSB, String command_string)
{
  uint8_t buf[10];
  uint16_t reg_val;

  buf[0] = 0; // SPI address = 0 for ADAU1466 write
  buf[1] = addr_MSB;
  buf[2] = addr_LSB;

  _spi->beginTransaction(SPISettings(10000000, MSBFIRST, SPI_MODE3));
  digitalWrite(_cs, LOW); // pull SS slow to prep other end for transfer

  for (int i = 0; i < 3; i++)
  {
    _spi->transfer(buf[i]); // output chip address, R/W, and register address
  }
  
  for (int i = 0; i < command_string.length(); i++)
  {
    _spi->transfer16((uint16_t)command_string[i]);
  }
  
  digitalWrite(_cs, HIGH); // pull SS high to signify end of data transfer
  _spi->endTransaction();
}

void ADAU1466_SPI::safeload_addr(word reg_num)
{                                     // put address into safeload registers
  uint8_t addr_MSB;                   // subaddress MSB
  uint8_t addr_LSB;                   // subaddress LSB
  uint8_t count = 4;                  // length = 2 bytes
  uint8_t Cmd_Data[4] = {0, 0, 0, 0}; // storage space zeroed out

  addr_LSB = lowByte(_Safeload_addr + 5); // Safeload address is at offset of 5
  addr_MSB = lowByte((_Safeload_addr + 5) >> 8);

  Cmd_Data[3] = lowByte(reg_num);
  Cmd_Data[2] = lowByte(reg_num >> 8);
  SPI_write_Mult(addr_MSB, addr_LSB, count, Cmd_Data);
}

void ADAU1466_SPI::safeload_data(uint8_t safeload_data_array[])
{                                     // data is in this array
  uint8_t addr_MSB;                   // subaddress MSB
  uint8_t addr_LSB;                   // subaddress LSB
  uint8_t count;                      // length = 2 bytes
  uint8_t Cmd_Data[4] = {0, 0, 0, 0}; // 32-bit Command data

  addr_LSB = lowByte(_Safeload_addr);
  addr_MSB = lowByte(_Safeload_addr >> 8);
  count = 4;
  SPI_write_Mult(addr_MSB, addr_LSB, count, safeload_data_array);
}

void ADAU1466_SPI::biquad_safe_load(word filter_reg, byte filter_coefs[][4])
{
  uint8_t Cmd_Data[4]; // allow up to 4 bytes of Command data for 8.24 data
  uint8_t addr_MSB;    // subaddress MSB
  uint8_t addr_LSB;    // subaddress LSB

  safeload_addr(filter_reg); // put the filter register into the safeload memory

  for (int j = 0; j < 5; j++)
  { // j is counting the coefficients:  5 for a biquad
    addr_LSB = lowByte(_Safeload_addr + j);
    addr_MSB = lowByte((_Safeload_addr + j) >> 8);

    for (int i = 0; i < 4; i++)
    {                                   // i is counting the bytes of the 8.24 word
      Cmd_Data[i] = filter_coefs[j][i]; // copy the formatted biquad coefficients into the Cmd_Data array, one biquad at a time
    }

    SPI_write_Mult(addr_MSB, addr_LSB, 4, Cmd_Data); // put data for coefficients in the right safeload data register

    /*
    Serial.print(addr_MSB, HEX);
    Serial.print(" ");
    Serial.println(addr_LSB, HEX);
    Serial.print(Cmd_Data[0], HEX);
    Serial.print(" hello ");
    Serial.print(Cmd_Data[1], HEX);
    Serial.print(" ");
    Serial.print(Cmd_Data[2], HEX);
    Serial.print(" ");
    Serial.println(Cmd_Data[3], HEX);
    */

  } // repeat for all 5 biquad coefficients
  safeload_xfer(5); // initiate transfer sequence (update all five coefficients)
}

void ADAU1466_SPI::safeload_xfer(uint8_t count)
{
  uint8_t addr_MSB;
  uint8_t addr_LSB;
  uint8_t Cmd_Data[4] = {0, 0, 0, 0}; // storage space

  addr_LSB = lowByte(_Safeload_addr + 6); // Number of words to write to page 1 is at Safeload Address + 6
  addr_MSB = lowByte((_Safeload_addr + 6) >> 8);
  Cmd_Data[3] = count;
  // Put the count (four bytes--32 bits) into Safeload_addr + 6 to initiate the transfer.  Count ranges from 1 to 5
  SPI_write_Mult(addr_MSB, addr_LSB, 4, Cmd_Data);
  // Complete the transfer by the second write; this time to Safeload_addr + 7
  Cmd_Data[3] = 0;
  SPI_write_Mult(addr_MSB, addr_LSB + 1, 4, Cmd_Data);
  delay(1);
}
