/*  The Volume table converts the 100 volume values into logarithmically spaced values for the ADAU1466
     There is an Excel spreadsheet in the library directory that calculates these values.  PROGMEM is defined
     in <avr/pgmspace.h> -- it is a way of putting the data in progam (flash) memory instead of wasting RAM.
*/

const byte Main_Vol_table[] PROGMEM = {
    0x00, 0x00, 0x06, 0x8D, 0x00, 0x00, 0x07, 0x5A, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x09, 0x41, //-80 to -77
    0x00, 0x00, 0x0A, 0x63, 0x00, 0x00, 0x0B, 0xA7, 0x00, 0x00, 0x0D, 0x13, 0x00, 0x00, 0x0E, 0xAB, //-76 to -73
    0x00, 0x00, 0x10, 0x76, 0x00, 0x00, 0x12, 0x78, 0x00, 0x00, 0x14, 0xB9, 0x00, 0x00, 0x17, 0x40,
    0x00, 0x00, 0x1A, 0x17, 0x00, 0x00, 0x1D, 0x46, 0x00, 0x00, 0x20, 0xD8, 0x00, 0x00, 0x24, 0xDA,
    0x00, 0x00, 0x29, 0x59, 0x00, 0x00, 0x2E, 0x65, 0x00, 0x00, 0x34, 0x0E, 0x00, 0x00, 0x3A, 0x68,
    0x00, 0x00, 0x41, 0x89, 0x00, 0x00, 0x49, 0x88, 0x00, 0x00, 0x52, 0x81, 0x00, 0x00, 0x5C, 0x92,
    0x00, 0x00, 0x67, 0xDE, 0x00, 0x00, 0x74, 0x8A, 0x00, 0x00, 0x82, 0xC2, 0x00, 0x00, 0x92, 0xB7,
    0x00, 0x00, 0xA4, 0x9E, 0x00, 0x00, 0xB8, 0xB4, 0x00, 0x00, 0xCF, 0x3E, 0x00, 0x00, 0xE8, 0x87,
    0x00, 0x01, 0x04, 0xE7, 0x00, 0x01, 0x24, 0xBD, 0x00, 0x01, 0x48, 0x75, 0x00, 0x01, 0x70, 0x89,
    0x00, 0x01, 0x9D, 0x81, 0x00, 0x01, 0xCF, 0xF5, 0x00, 0x02, 0x08, 0x92, 0x00, 0x02, 0x48, 0x17,
    0x00, 0x02, 0x8F, 0x5C, 0x00, 0x02, 0xDF, 0x53, 0x00, 0x03, 0x39, 0x0C, 0x00, 0x03, 0x9D, 0xB8,
    0x00, 0x04, 0x0E, 0xAC, 0x00, 0x04, 0x8D, 0x69, 0x00, 0x05, 0x1B, 0x9D, 0x00, 0x05, 0xBB, 0x2B,
    0x00, 0x06, 0x6E, 0x30, 0x00, 0x07, 0x37, 0x0E, 0x00, 0x08, 0x18, 0x6E, 0x00, 0x09, 0x15, 0x4E,
    0x00, 0x0A, 0x31, 0x08, 0x00, 0x0B, 0x6F, 0x62, 0x00, 0x0C, 0xD4, 0x94, 0x00, 0x0E, 0x65, 0x5C,
    0x00, 0x10, 0x27, 0x0A, 0x00, 0x12, 0x1F, 0x97, 0x00, 0x14, 0x55, 0xB5, 0x00, 0x16, 0xD0, 0xE6,
    0x00, 0x19, 0x99, 0x99, 0x00, 0x1C, 0xB9, 0x42, 0x00, 0x20, 0x3A, 0x7E, 0x00, 0x24, 0x29, 0x34,
    0x00, 0x28, 0x92, 0xC1, 0x00, 0x2D, 0x86, 0x21, 0x00, 0x33, 0x14, 0x26, 0x00, 0x39, 0x4F, 0xAE,
    0x00, 0x40, 0x4D, 0xE6, 0x00, 0x48, 0x26, 0x8D, 0x00, 0x50, 0xF4, 0x4D, 0x00, 0x5A, 0xD5, 0x0C,
    0x00, 0x65, 0xEA, 0x59, 0x00, 0x72, 0x59, 0xDB, 0x00, 0x80, 0x4D, 0xCE, 0x00, 0x8F, 0xF5, 0x99,
    0x00, 0xA1, 0x86, 0x6B, 0x00, 0xB5, 0x3B, 0xEF, 0x00, 0xCB, 0x59, 0x18, 0x00, 0xE4, 0x29, 0x05,
    0x01, 0x00, 0x00, 0x00, 0x01, 0x1F, 0x3C, 0x99, 0x01, 0x42, 0x48, 0xEF, 0x01, 0x69, 0x9C, 0x0F, // 0 to +4
    0x01, 0x95, 0xBB, 0x8F, 0x01, 0xC7, 0x3D, 0x51, 0x01, 0xFE, 0xC9, 0x82                          //+4 to +6
};

/*  The Volume Trim table converts the 20 or so volume trim values for each channel into logarithmically spaced
     values for the ADAU1701.  This is another tab in the Excel spreadsheet
*/
const byte Trim_Volume_table[] PROGMEM = {
    0x00, 0x50, 0xF4, 0x4D,
    0x00, 0x5A, 0xD5, 0x0C,
    0x00, 0x65, 0xEA, 0x59,
    0x00, 0x72, 0x59, 0xDB,
    0x00, 0x80, 0x4D, 0xCE,
    0x00, 0x8F, 0xF5, 0x99,
    0x00, 0xA1, 0x86, 0x6B,
    0x00, 0xB5, 0x3B, 0xEF,
    0x00, 0xCB, 0x59, 0x18,
    0x00, 0xE4, 0x29, 0x05,
    0x01, 0x00, 0x00, 0x00};

const byte Delay_table[] PROGMEM = {
    0x1, 0x2, 0x3, 0x4, 0x5, 0x6,
    0x7, 0x9, 0xB, 0xE, 0x12, 0x16};

/*  The original versions of this code "cleverly" converted the text entries in the HCI table values to floating point.  However, that approach
 *   requires some discipline to make sure the HCI table is in the right form, and it is probably "too cutsie" to be easily supported.  Instead,
 *   we have a look-up table that converts the HCI code into the corresponding floating point values.  This approach has its own issues, but it
 *   is somewhat easier to follow and it makes the library calls less dependent on the HCI. Remember:  HCI table has text; Lookup_tables.h has floating point
 */

const float EQ_Gain_table[] PROGMEM = {
    -10.0, -8.0, -6.0, -4.0, -2.0, 0.0, 2.0, 4.0, 6.0, 8.0, 10.0};

const float ST_T_Xover_freq_table[] PROGMEM = {
    3000, 4000, 5000, 6000, 7000, 8000};

const float T_M_Xover_freq_table[] PROGMEM = {
    1000, 1500, 2000, 3000, 4000, 5000};

const float M_W_Xover_freq_table[] PROGMEM = {
    300, 500, 750, 1000, 1500, 2000};

const float W_S_Xover_freq_table[] PROGMEM = {
    80, 100, 120, 150, 200, 300};

const float T_W_Xover_freq_table[] PROGMEM = {
    1000, 1500, 2000, 2500, 3000, 3500, 4000};

const float BSC_Freq_table[] PROGMEM = {
    300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};

const float BSC_Gain_table[] PROGMEM = {
    0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};

const float Bass_Freq_table[] PROGMEM = {
    15.0, 20.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 120.0};

const float Bass_Q_table[] PROGMEM = {
    0.5, 0.7, 1.0, 1.5, 2.2, 2.9};

const float Bass_Gain_table[] PROGMEM = {
    1.0, 2.0, 3.0, 4.0, 5.0, 6.0};

const byte SB_table_length = 36;
const byte SuperBass_freq_table[][SB_table_length] PROGMEM = {
    {0x00, 0x7F, 0xD5, 0x1B, 0xFF, 0x00, 0x55, 0xC9, 0x00, 0xFF, 0xAA, 0x1A, 0xFF, 0x80, 0x55, 0xAD, 0x00, 0x7F, 0xD5, 0x2A, 0x00, 0x7F, 0xAA, 0x53, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x00, 0x00, 0x1D, 0x00, 0x00, 0x2A, 0xD6}, // 20
    {0x00, 0x7F, 0xAA, 0x37, 0xFF, 0x00, 0xAB, 0x92, 0x00, 0xFF, 0x53, 0xFB, 0xFF, 0x80, 0xAB, 0x20, 0x00, 0x7F, 0xAA, 0x70, 0x00, 0x7F, 0x54, 0xE0, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x55, 0x90}, // 40
    {0x00, 0x7F, 0x7F, 0x52, 0xFF, 0x01, 0x01, 0x5B, 0x00, 0xFE, 0xFD, 0xA3, 0xFF, 0x81, 0x00, 0x5A, 0x00, 0x7F, 0x7F, 0xD3, 0x00, 0x7E, 0xFF, 0xA5, 0x00, 0x00, 0x00, 0x81, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x80, 0x2D}, // 60
    {0x00, 0x7F, 0x54, 0x6E, 0xFF, 0x01, 0x57, 0x24, 0x00, 0xFE, 0xA7, 0x13, 0xFF, 0x81, 0x55, 0x5A, 0x00, 0x7F, 0x55, 0x52, 0x00, 0x7E, 0xAA, 0xA3, 0x00, 0x00, 0x00, 0xE5, 0x00, 0x00, 0x01, 0xCA, 0x00, 0x00, 0xAA, 0xAE}, // 80
    {0x00, 0x7F, 0x29, 0x8A, 0xFF, 0x01, 0xAC, 0xEC, 0x00, 0xFE, 0x50, 0x4A, 0xFF, 0x81, 0xAA, 0x22, 0x00, 0x7F, 0x2A, 0xED, 0x00, 0x7E, 0x55, 0xDA, 0x00, 0x00, 0x01, 0x65, 0x00, 0x00, 0x02, 0xCA, 0x00, 0x00, 0xD5, 0x13}, // 100
    {0x00, 0x7E, 0xBE, 0x52, 0xFF, 0x02, 0x83, 0x5C, 0x00, 0xFD, 0x76, 0x63, 0xFF, 0x82, 0x7D, 0x1A, 0x00, 0x7E, 0xC1, 0x6B, 0x00, 0x7D, 0x82, 0xD6, 0x00, 0x00, 0x03, 0x21, 0x00, 0x00, 0x06, 0x41, 0x00, 0x01, 0x3E, 0x95}, // 150
    {0x00, 0x7E, 0x53, 0x1E, 0xFF, 0x03, 0x59, 0xC5, 0x00, 0xFC, 0x9B, 0x26, 0xFF, 0x83, 0x4E, 0xAF, 0x00, 0x7E, 0x58, 0x96, 0x00, 0x7C, 0xB1, 0x2C, 0x00, 0x00, 0x05, 0x8B, 0x00, 0x00, 0x0B, 0x15, 0x00, 0x01, 0xA7, 0x6A}, // 200
    {0x00, 0x7D, 0xE7, 0xEE, 0xFF, 0x04, 0x30, 0x25, 0x00, 0xFB, 0xBE, 0x98, 0xFF, 0x84, 0x1E, 0xE2, 0x00, 0x7D, 0xF0, 0x6C, 0x00, 0x7B, 0xE0, 0xD7, 0x00, 0x00, 0x08, 0xA2, 0x00, 0x00, 0x11, 0x43, 0x00, 0x02, 0x0F, 0x94}, // 250
    {0x00, 0x7D, 0x7C, 0xC3, 0xFF, 0x05, 0x06, 0x7A, 0x00, 0xFA, 0xE0, 0xC0, 0xFF, 0x84, 0xED, 0xB3, 0x00, 0x7D, 0x88, 0xE9, 0x00, 0x7B, 0x11, 0xD3, 0x00, 0x00, 0x0C, 0x63, 0x00, 0x00, 0x18, 0xC7, 0x00, 0x02, 0x77, 0x17}  // 300
};

const byte SuperBass_Int_and_Gain_table[][4] PROGMEM = {
    {0x00, 0x0C, 0xCC, 0xCD}, {0x00, 0x19, 0x99, 0x9A}, {0x00, 0x26, 0x66, 0x66}, {0x00, 0x33, 0x33, 0x33}, {0x00, 0x40, 0x00, 0x00}, {0x00, 0x4C, 0xCC, 0xCD}, {0x00, 0x59, 0x99, 0x9A}, {0x00, 0x66, 0x66, 0x66}, {0x00, 0x73, 0x33, 0x33}, {0x00, 0x80, 0x00, 0x00}, {0x00, 0x8C, 0xCC, 0xCD}, {0x00, 0x99, 0x99, 0x9A}, {0x00, 0xA6, 0x66, 0x66}, {0x00, 0xB3, 0x33, 0x33}, {0x00, 0xC0, 0x00, 0x00}, {0x00, 0xCC, 0xCC, 0xCD}, {0x00, 0xD9, 0x99, 0x9A}, {0x00, 0xE6, 0x66, 0x66}, {0x00, 0xF3, 0x33, 0x33}, {0x01, 0x00, 0x00, 0x00}, {0x01, 0x0C, 0xCC, 0xCD}, {0x01, 0x19, 0x99, 0x9A}, {0x01, 0x26, 0x66, 0x66}, {0x01, 0x33, 0x33, 0x33}, {0x01, 0x40, 0x00, 0x00}, {0x01, 0x4C, 0xCC, 0xCD}, {0x01, 0x59, 0x99, 0x9A}, {0x01, 0x66, 0x66, 0x66}, {0x01, 0x73, 0x33, 0x33}, {0x01, 0x80, 0x00, 0x00}};

const byte DB_Threshold_table[][4] PROGMEM = {
    {0x00, 0xFF, 0x64, 0xC1}, {0x00, 0xEA, 0x44, 0x32}, {0x00, 0xD6, 0xE3, 0x0D}, {0x00, 0xC5, 0x1C, 0x50}, {0x00, 0xB4, 0xCE, 0x08}, {0x00, 0xA5, 0xD9, 0x10}, {0x00, 0x98, 0x20, 0xD7}, //-24, -21. -18, -15, -12, -9, -6
    {0x00, 0x8B, 0x8B, 0x2A},
    {0x00, 0x80, 0x00, 0x00},
    {0x00, 0x6E, 0xD7, 0xEB},
    {0x00, 0x5F, 0xFC, 0x89},
    {0x00, 0x53, 0x1E, 0xF0},
    {0x00, 0x47, 0xFA, 0xCD} //-3, -0. +5, +10, +15, +20
};

const byte DB_Time_constant_table[][4] PROGMEM = {
    {0x00, 0x80, 0x00, 0x00}, {0x00, 0x00, 0x0D, 0x8F}, {0x00, 0x00, 0x06, 0xC8}, {0x00, 0x00, 0x04, 0x85}, {0x00, 0x00, 0x03, 0x64}, // 0, 50. 100, 150, 200
    {0x00, 0x00, 0x02, 0xB6},
    {0x00, 0x00, 0x02, 0x43},
    {0x00, 0x00, 0x01, 0xB2},
    {0x00, 0x00, 0x01, 0x5B} // 250, 300, 400, 500
};

const byte DB_Bass_Boost_table[][4] PROGMEM = {
    {0x00, 0x80, 0x00, 0x00}, {0x00, 0x56, 0x89, 0xE3}, {0x00, 0x3D, 0x43, 0xC0}, {0x00, 0x2C, 0x61, 0xE0}, // 0, 3. 6, 9
    {0x00, 0x1E, 0xB4, 0x7F},
    {0x00, 0x15, 0xBC, 0xCE},
    {0x00, 0x10, 0x1D, 0x3F},
    {0x00, 0x0C, 0xCC, 0xCD} // 12, 15, 18, 20
};

const byte DB_Bass_Freq_table[][4] PROGMEM = {
    {0x00, 0x00, 0x55, 0xC9}, {0x00, 0x00, 0xAB, 0x93}, {0x00, 0x01, 0x01, 0x5C}, {0x00, 0x01, 0x57, 0x25}, {0x00, 0x01, 0xAC, 0xEE}, // 20, 40, 60, 80, 100
    {0x00, 0x02, 0x83, 0x63},
    {0x00, 0x03, 0x59, 0xD7},
    {0x00, 0x04, 0x30, 0x48},
    {0x00, 0x05, 0x06, 0xB7} // 150, 200, 250, 300
};

const byte DB_Bass_Coef_table[][4] PROGMEM = {
    {0x00, 0x00, 0x00, 0x39}, {0x00, 0x00, 0x00, 0x73}, {0x00, 0x00, 0x00, 0x39}, {0x00, 0xFF, 0x0D, 0x53}, {0xFF, 0x80, 0xF1, 0xC8}, // 20Hz
    {0x00, 0x00, 0x00, 0xE4},
    {0x00, 0x00, 0x01, 0xC9},
    {0x00, 0x00, 0x00, 0xE4},
    {0x00, 0xFE, 0x1A, 0xA8},
    {0xFF, 0x81, 0xE1, 0xC7}, // 40Hz
    {0x00, 0x00, 0x02, 0x00},
    {0x00, 0x00, 0x04, 0x00},
    {0x00, 0x00, 0x02, 0x00},
    {0x00, 0xFD, 0x28, 0x00},
    {0xFF, 0x82, 0xD0, 0x01}, // 60Hz
    {0x00, 0x00, 0x03, 0x8A},
    {0x00, 0x00, 0x07, 0x15},
    {0x00, 0x00, 0x03, 0x8A},
    {0x00, 0xFC, 0x35, 0x5D},
    {0xFF, 0x83, 0xBC, 0x79}, // 80Hz
    {0x00, 0x00, 0x05, 0x83},
    {0x00, 0x00, 0x0B, 0x06},
    {0x00, 0x00, 0x05, 0x83},
    {0x00, 0xFB, 0x42, 0xC1},
    {0xFF, 0x84, 0xA7, 0x32}, // 100Hz
    {0x00, 0x00, 0x0C, 0x4A},
    {0x00, 0x00, 0x18, 0x95},
    {0x00, 0x00, 0x0C, 0x4A},
    {0x00, 0xF8, 0xE4, 0x62},
    {0xFF, 0x86, 0xEA, 0x75}, // 150Hz
    {0x00, 0x00, 0x15, 0xA7},
    {0x00, 0x00, 0x2B, 0x4E},
    {0x00, 0x00, 0x15, 0xA7},
    {0x00, 0xF6, 0x86, 0x4D},
    {0xFF, 0x89, 0x23, 0x17}, // 200Hz
    {0x00, 0x00, 0x21, 0x87},
    {0x00, 0x00, 0x43, 0x0F},
    {0x00, 0x00, 0x21, 0x87},
    {0x00, 0xF4, 0x28, 0x99},
    {0xFF, 0x8B, 0x51, 0x4A}, // 250Hz
    {0x00, 0x00, 0x2F, 0xDA},
    {0x00, 0x00, 0x5F, 0xB4},
    {0x00, 0x00, 0x2F, 0xDA},
    {0x00, 0xF1, 0xCB, 0x58},
    {0xFF, 0x8D, 0x75, 0x40} // 300Hz
};

/* Line Array Look-up tables
 */
const byte LA_Woofer_Delay_table_14[][7] PROGMEM = {
    /* {0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1},
     {0x18, 0x13, 0xE, 0x9, 0x6, 0x4, 0x2, 0x1},
     {0x28, 0x1E, 0x16, 0xF, 0x9, 0x5, 0x2, 0x1},
     {0x32, 0x26, 0x1C, 0x13, 0xC, 0x7, 0x3, 0x1},
     {0x3E, 0x30, 0x23, 0x18, 0xF, 0x8, 0x3, 0x1} */

    {0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1},
    {0x18, 0x11, 0xC, 0x8, 0x4, 0x2, 0x1},
    {0x27, 0x1C, 0x13, 0xC, 0x7, 0x3, 0x1},
    {0x31, 0x24, 0x19, 0xF, 0x8, 0x3, 0x1},
    {0x3D, 0x2D, 0x1F, 0x13, 0xA, 0x4, 0x1}};

const byte LA_Tweeter_Delay_table_24[][12] PROGMEM = {
    {0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1},
    {0x19, 0x15, 0x12, 0xE, 0xB, 0x9, 0x7, 0x5, 0x3, 0x2, 0x1, 0x1},
    {0x29, 0x23, 0x1D, 0x17, 0x12, 0xE, 0xA, 0x7, 0x5, 0x3, 0x2, 0x1},
    {0x34, 0x2C, 0x25, 0x1E, 0x18, 0x12, 0xD, 0x9, 0x6, 0x3, 0x2, 0x1},
    {0x41, 0x37, 0x2E, 0x25, 0x1E, 0x17, 0x11, 0xB, 0x7, 0x4, 0x2, 0x1}};

const byte LA_Woofer_Vol_table_14[][32] PROGMEM = {
    /*{0x5E, 0x4A, 0xDE, 0x5E, 0x4A, 0xDE, 0x5E, 0x4A, 0xDE, 0x5E, 0x4A, 0xDE, 0x5E, 0x4A, 0xDE, 0x5E, 0x4A, 0xDE, 0x5E, 0x4A, 0xDE, 0x5E, 0x4A, 0xDE}, // cap angle = 0
    {0x4B, 0x8D, 0xA3, 0x52, 0x44, 0x2C, 0x58, 0xA3, 0x1E, 0x5E, 0x65, 0x62, 0x63, 0x45, 0xE3, 0x66, 0xFF, 0x8A, 0x69, 0x4D, 0x41, 0x69, 0xE9, 0xF2}, // cap angle = 50
    {0x3D, 0xEA, 0x60, 0x49, 0x83, 0x9A, 0x54, 0x85, 0x7E, 0x5E, 0x78, 0xAE, 0x66, 0xE5, 0xCD, 0x6D, 0x55, 0x7E, 0x71, 0x50, 0x62, 0x72, 0x5F, 0x1D}, // cap angle = 80
    {0x33, 0x8B, 0xAD, 0x42, 0xDB, 0xE8, 0x51, 0x64, 0x55, 0x5E, 0x87, 0x5A, 0x69, 0xA7, 0x60, 0x72, 0x26, 0xCC, 0x77, 0x68, 0x07, 0x78, 0xCD, 0x77}, // cap angle = 100
    {0x27, 0xF0, 0xA6, 0x3B, 0x69, 0x34, 0x4D, 0xE3, 0xB5, 0x5E, 0x97, 0xC6, 0x6C, 0xBD, 0x05, 0x77, 0x8B, 0x10, 0x7E, 0x39, 0x84, 0x80, 0x00, 0x00}  // cap angle = 120
*/
    {0x00, 0xBF, 0xC9, 0x24, 0x00, 0xBF, 0xC9, 0x24, 0x00, 0xBF, 0xC9, 0x24, 0x00, 0xBF, 0xC9, 0x24,
     0x00, 0xBF, 0xC9, 0x24, 0x00, 0xBF, 0xC9, 0x24, 0x00, 0xBF, 0xC9, 0x24}, // cap angle = 0

    {0x00, 0x9C, 0x34, 0xB4, 0x00, 0xAB, 0x4B, 0x09, 0x00, 0xB9, 0x3E, 0xE5, 0x00, 0xC5, 0x49, 0x61,
     0x00, 0xCE, 0xA3, 0x92, 0x00, 0xD4, 0x86, 0x92, 0x00, 0xD6, 0x2B, 0x75}, // cap angle = 50

    {0x00, 0x82, 0x92, 0x3D, 0x00, 0x9C, 0x87, 0x4E, 0x00, 0xB4, 0x88, 0xA1, 0x00, 0xC9, 0x3F, 0xFD,
     0x00, 0xD9, 0x57, 0x28, 0x00, 0xE3, 0x77, 0xEB, 0x00, 0xE6, 0x4C, 0x0D}, // cap angle = 80

    {0x00, 0x6F, 0x39, 0x2A, 0x00, 0x91, 0x62, 0x87, 0x00, 0xB0, 0xFA, 0x31, 0x00, 0xCC, 0x3D, 0xC5,
     0x00, 0xE1, 0x6A, 0xE1, 0x00, 0xEE, 0xBF, 0x21, 0x00, 0xF2, 0x78, 0x22}, // cap angle = 100

    {0x00, 0x59, 0xB7, 0x4B, 0x00, 0x84, 0xFF, 0x5C, 0x00, 0xAD, 0x06, 0x24, 0x00, 0xCF, 0x91, 0x06,
     0x00, 0xEA, 0x65, 0x60, 0x00, 0xFB, 0x48, 0x93, 0x01, 0x00, 0x00, 0x00} // cap angle = 120
};

const byte LA_Tweeter_Vol_table_24[][48] PROGMEM = {
    /*{0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25, 0x59, 0xCD, 0x25}, ////cap angle = 0
    {0x45, 0x1A, 0xC5, 0x49, 0xA9, 0x6E, 0x4E, 0x2D, 0x0A, 0x52, 0x8F, 0x65, 0x56, 0xBA, 0x4E, 0x5A, 0x97, 0x93, 0x5E, 0x11, 0x00, 0x61, 0x10, 0x63, 0x63, 0x7F, 0x8B, 0x65, 0x48, 0x45, 0x66, 0x54, 0x5E, 0x66, 0x8D, 0xA4},
    {0x35, 0x9A, 0x31, 0x3D, 0x92, 0xB4, 0x45, 0x77, 0xE2, 0x4D, 0x22, 0xE8, 0x54, 0x6C, 0xF3, 0x5B, 0x2F, 0x32, 0x61, 0x42, 0xD2, 0x66, 0x80, 0xFF, 0x6A, 0xC2, 0xE8, 0x6D, 0xE1, 0xBA, 0x6F, 0xB6, 0xA3, 0x70, 0x1A, 0xCF},
    {0x29, 0x8E, 0x99, 0x34, 0x2E, 0x18, 0x3E, 0xB3, 0xD3, 0x48, 0xEC, 0x0B, 0x52, 0xA3, 0x05, 0x5B, 0xA5, 0x02, 0x63, 0xBE, 0x44, 0x6A, 0xBB, 0x0E, 0x70, 0x67, 0xA3, 0x74, 0x90, 0x44, 0x77, 0x01, 0x34, 0x77, 0x86, 0xB6},
    {0x1B, 0xCD, 0xC9, 0x29, 0x74, 0x89, 0x36, 0xFA, 0x2D, 0x44, 0x1C, 0x37, 0x50, 0x98, 0x29, 0x5C, 0x2B, 0x86, 0x66, 0x93, 0xD0, 0x6F, 0x8E, 0x8A, 0x76, 0xD9, 0x36, 0x7C, 0x31, 0x57, 0x7F, 0x54, 0x6F, 0x80, 0x00, 0x00}};
    */
    {0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A,
     0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A,
     0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A, 0x00, 0xB3, 0x9A, 0x4A}, // cap angle = 0

    {0x00, 0x8A, 0x35, 0x8B, 0x00, 0x93, 0x52, 0xDD, 0x00, 0x9C, 0x5A, 0x14, 0x00, 0xA5, 0x1E, 0xCB,
     0x00, 0xAD, 0x74, 0x9D, 0x00, 0xB5, 0x2F, 0x26, 0x00, 0xBC, 0x22, 0x00, 0x00, 0xC2, 0x20, 0xC7,
     0x00, 0xC6, 0xFF, 0x17, 0x00, 0xCA, 0x90, 0x8A, 0x00, 0xCC, 0xA8, 0xBD, 0x00, 0xCD, 0x1B, 0x49}, // cap angle = 50

    {0x00, 0x6B, 0x34, 0x63, 0x00, 0x7B, 0x25, 0x69, 0x00, 0x8A, 0xEF, 0xC4, 0x00, 0x9A, 0x45, 0xD0,
     0x00, 0xA8, 0xD9, 0xE7, 0x00, 0xB6, 0x5E, 0x65, 0x00, 0xC2, 0x85, 0xA4, 0x00, 0xCD, 0x01, 0xFF,
     0x00, 0xD5, 0x85, 0xD1, 0x00, 0xDB, 0xC3, 0x75, 0x00, 0xDF, 0x6D, 0x46, 0x00, 0xE0, 0x35, 0x9F}, // cap angle = 80

    {0x00, 0x53, 0x1D, 0x33, 0x00, 0x68, 0x5C, 0x30, 0x00, 0x7D, 0x67, 0xA6, 0x00, 0x91, 0xD8, 0x17,
     0x00, 0xA5, 0x46, 0x0B, 0x00, 0xB7, 0x4A, 0x04, 0x00, 0xC7, 0x7C, 0x89, 0x00, 0xD5, 0x76, 0x1D,
     0x00, 0xE0, 0xCF, 0x46, 0x00, 0xE9, 0x20, 0x89, 0x00, 0xEE, 0x02, 0x69, 0x00, 0xEF, 0x0D, 0x6C}, // cap angle = 100

    {0x00, 0x37, 0x9B, 0x92, 0x00, 0x52, 0xE9, 0x12, 0x00, 0x6D, 0xF4, 0x5A, 0x00, 0x88, 0x38, 0x6E,
     0x00, 0xA1, 0x30, 0x52, 0x00, 0xB8, 0x57, 0x0C, 0x00, 0xCD, 0x27, 0xA1, 0x00, 0xDF, 0x1D, 0x15,
     0x00, 0xED, 0xB2, 0x6D, 0x00, 0xF8, 0x62, 0xAF, 0x00, 0xFE, 0xA8, 0xDE, 0x01, 0x00, 0x00, 0x00} // cap angle = 120
};
