/*
  ADAU1466_I2C - Library for communicating with the ADAU1466.
  The ADAU1466 uses 16-bit addressing, so the simple wire instructions aren't adequate.  These routines
     provide the 16-bit addressing.

     These routines use the Wire library, which must be initialized separately.

  Created by Neil Davis, March, 2023.
*/

#ifndef ADAU1466_I2C_H
#define ADAU1466_I2C_H

#include "Arduino.h"
extern bool setup_done;

class ADAU1466_I2C
{
  public:
    ADAU1466_I2C(uint8_t I2C_addr, word Safeload_addr);

    void Read_block(byte MSB, byte LSB, uint8_t (&Data_block)[16], int count);
    void I2C_write_Mult(uint8_t addr_MSB, uint8_t addr_LSB, uint8_t count, uint8_t command_buffer[]);
    void safeload_addr(word reg_num);
    void safeload_data(uint8_t safeload_data_array[]);
    void biquad_safe_load(word filter_reg, byte ADAU1466_coefs [5][4]);
    void safeload_xfer(uint8_t count);
    void ADAU1466_soft_reset();
    void Load_parameters(const byte* Param_table_pointer);    

  private:
    //these are values that need to get set and stay set after initialization, since they get used later
    uint8_t _I2C_addr;
    word  _Safeload_addr;

    //Routines used internally
};

#endif
