#include "Arduino.h"
#include "ADAU1466_I2C.h"
#include <Wire.h>

ADAU1466_I2C::ADAU1466_I2C(uint8_t I2C_addr, word Safeload_addr)
{
  _I2C_addr = I2C_addr;
  _Safeload_addr = Safeload_addr;
}

void ADAU1466_I2C::  Read_block(byte MSB, byte LSB, uint8_t (& Data_block) [16], int count)
{
  size_t count_t = count;
  uint8_t addr[] = {MSB, LSB};
  Wire.beginTransmission(_I2C_addr);   // transmit to device at I2C_addr
  Wire.write(addr, 2);
  Wire.endTransmission(false);           //Address counter set
  Wire.requestFrom(_I2C_addr, count_t, true); //request a block of bytes
  uint8_t x = 0;
  while (Wire.available()) Data_block[x++] = Wire.read();
}

void ADAU1466_I2C::  I2C_write_Mult(uint8_t addr_MSB, uint8_t addr_LSB, uint8_t count, uint8_t command_buffer[])
{
  uint8_t addr[7];
  addr[0] = addr_MSB;
  addr[1] = addr_LSB;
  for (uint8_t x = 0; x < count; x++) {
    addr[x + 2] = command_buffer[x];        //copy data into buffer
  }

  Wire.beginTransmission(_I2C_addr);     // transmit to device at I2C_addr
  Wire.write(addr, count + 2);          //write subaddress followed by data
  Wire.endTransmission();
}

void ADAU1466_I2C::  safeload_addr(word reg_num) {    //put address into safeload registers
  uint8_t addr_MSB;                   //subaddress MSB
  uint8_t addr_LSB;                   //subaddress LSB
  uint8_t count = 4;                  //length = 2 bytes
  uint8_t Cmd_Data[4] = {0,0,0,0}; 	  //storage space zeroed out


  addr_LSB = lowByte(_Safeload_addr + 5);			//Safeload address is at offset of 5
  addr_MSB = lowByte(_Safeload_addr + 5 >> 8);

  Cmd_Data[3] = lowByte(reg_num);
  Cmd_Data[2] = lowByte(reg_num >> 8);
  I2C_write_Mult(addr_MSB, addr_LSB, count, Cmd_Data);
}


void ADAU1466_I2C::  safeload_data(uint8_t safeload_data_array[]) {          //data is in this array
  uint8_t addr_MSB;                   //subaddress MSB
  uint8_t addr_LSB;                   //subaddress LSB
  uint8_t count;                      //length = 2 bytes
  uint8_t Cmd_Data[4] = {0,0,0,0};    //32-bit Command data

  addr_LSB = lowByte(_Safeload_addr);			
  addr_MSB = lowByte(_Safeload_addr >> 8);
  count = 4;
  I2C_write_Mult(addr_MSB, addr_LSB, count, safeload_data_array);
}


void ADAU1466_I2C::  biquad_safe_load(word filter_reg, byte filter_coefs[][4] )  {
  uint8_t Cmd_Data[4];                //allow up to 4 bytes of Command data for 8.24 data
  uint8_t addr_MSB;                   //subaddress MSB
  uint8_t addr_LSB;                   //subaddress LSB
 
  safeload_addr(filter_reg);          //put the filter register into the safeload memory


  for (int j = 0; j < 5; j++) {		//j is counting the coefficients:  5 for a biquad
    addr_LSB = lowByte(_Safeload_addr + j);			
    addr_MSB = lowByte((_Safeload_addr + j) >> 8);

    for (int i = 0; i < 4; i++) {		//i is counting the bytes of the 8.24 word
      Cmd_Data[i] = filter_coefs[j][i];	//copy the formatted biquad coefficients into the Cmd_Data array, one biquad at a time
    } 


    I2C_write_Mult(addr_MSB, addr_LSB, 4, Cmd_Data);   //put data for coefficients in the right safeload data register

Serial.print(addr_MSB, HEX);Serial.print(" ");Serial.println(addr_LSB, HEX);
Serial.print(Cmd_Data[0], HEX);Serial.print(" ");Serial.print(Cmd_Data[1], HEX);Serial.print(" ");Serial.print(Cmd_Data[2], HEX);Serial.print(" ");Serial.println(Cmd_Data[3], HEX);


  }                                              	 //repeat for all 5 biquad coefficients
  safeload_xfer(5);                                    //initiate transfer sequence (update all five coefficients)
}


void ADAU1466_I2C::  safeload_xfer(uint8_t count) {          
  uint8_t addr_MSB;
  uint8_t addr_LSB; 
  uint8_t Cmd_Data[4] = {0,0,0,0}; 				//storage space

  addr_LSB = lowByte(_Safeload_addr + 6);			//Number of words to write to page 1 is at Safeload Address + 6
  addr_MSB = lowByte((_Safeload_addr + 6) >> 8);
  Cmd_Data[3] = count;
  //Put the count (four bytes--32 bits) into Safeload_addr + 6 to initiate the transfer.  Count ranges from 1 to 5
  I2C_write_Mult(addr_MSB, addr_LSB, 4, Cmd_Data); 
  //Complete the transfer by the second write; this time to Safeload_addr + 7
  Cmd_Data[3] = 0;
  I2C_write_Mult(addr_MSB, addr_LSB + 1, 4, Cmd_Data); 
  delay(1);
}


void ADAU1466_I2C::  ADAU1466_soft_reset() {
  //reset  Address 081C; DSP Core Control
  uint8_t addr_MSB = 0x08;            //subaddress MSB
  uint8_t addr_LSB;                   //subaddress LSB
  uint8_t count = 2;                  //length = 2 bytes
  uint8_t Cmd_Data[5];                //allow up to 5 bytes of Command data

  addr_LSB = 0x1C;   //subaddress LSB = DSP Core Control
  count = 2;      //length
  Cmd_Data[0] = 0;      //Data MSB = 0
  Cmd_Data[1] = 0;      //Data LSB = 0 = stop everything
  I2C_write_Mult(addr_MSB, addr_LSB, count, Cmd_Data);   //send the command
  delay(10);           //wait for at least two cycles
}


