/*
  ADAU1466_DSP - Library for calculating the filter coefficients and implementing the filters and crossovers
	for the Audiodeveloper DSP boards.
  Updated by Neil Davis, March, 2023.
*/

#ifndef ADAU1466_DSP_H
#define ADAU1466_DSP_H

#include "Arduino.h"
#include <ADAU1466_Shared_enums.h>    //this file defines the filter types--it must be included to use this library
#include <ADAU1466_I2C.h>
#include <ADAU1466_Bilinear.h>

enum Xovers {none, BW_1, BW_3, LR_2, LR_4, LR_8, BW_2, BW_4, BW_5, BW_6, Bes_2, Bes_3, Bes_4, Bes_5, Bes_6,  LR_6, LR_10, LR_12, LR_14};    //This must agree with the list in HCI.h

class ADAU1466_DSP
{

  public:
    ADAU1466_DSP();

    Shared_enum::BQ_spec get_biquad_spec(float FC, Shared_enum::Xovers x_type);               //determine what filter types are needed and return that info in the biquad_spec structure
    Shared_enum::Xovers convert_Xover_code(Shared_enum::Xover_drivers driver_set, byte freq_code);
    float convert_freq_code(Shared_enum::Xover_drivers driver_set, byte freq_code);                           //use current HCI value to look u[ the corresponding floating point value
    void BQ5_Xover_calc(Shared_enum::BQ_spec BQ, word BQ5_addresses[5][2]);
    void BQ3_Xover_calc(Shared_enum::BQ_spec BQ, word BQ3_addresses[3][2]);
    void filter_calc(Shared_enum::Filter_spec Filter, word BQ_address);

  private:

    Shared_enum::Xovers x_type;
    byte ADAU1466_coefs [5][4];   //five coefficients, each a 32-bit 8.24 value.  
    byte BQ_coefs [5][4];   //five 28-bit values.  Will need to prepend 12 bits of zeroes to make into 40-bit data
    float _coef_array[6];         //array to hold one set of biquad coefficents processed by Bilinear() and sent to coef_to_ADAU1466()

    void BQ5_biquad_load(byte biquad, float Freq, byte order, float q, word BQ5_addresses[5][2]);
    void BQ3_biquad_load(byte biquad, float Freq, byte order, float q, word BQ3_addresses[5][2]);
    void fill_BQ5_with_none(byte number_of_biquads, word BQ5_addresses[5][2]);
    void fill_BQ3_with_none(byte number_of_biquads, word BQ3_addresses[3][2]);
    void coef_passthrough();
    void coef_to_ADAU1466(float coef_array[6]);
};

#endif
