/*
  Bilinear Transform - Library for calculating the digital filter coefficients from the time domain specification
  Created by Neil Davis, January, 2021.
*/

#ifndef ADAU1466_Bilinear_H
#define ADAU1466_Bilinear_H

#include "Arduino.h"
#include <ADAU1466_Shared_enums.h>  //this file defines the filter types--it must be included to use this library

class ADAU1466_Bilinear
{

  public:
    ADAU1466_Bilinear();
    void coef_calc(float FC, float gain, float Q, Shared_enum::tfilters filtertype, float (& coef_array)[6]);

  private:
    float Fs = 48000.0;             //sampling frequency
    float k;
    float w;
    float alpha;
    float beta;
    float A;
    float wS;
    float wC;
    float scalefactor;


    float coefb0(Shared_enum::tfilters filtertype);
    float coefb1(Shared_enum::tfilters filtertype);
    float coefb2(Shared_enum::tfilters filtertype);
    float coefa0(Shared_enum::tfilters filtertype);
    float coefa1(Shared_enum::tfilters filtertype);
    float coefa2(Shared_enum::tfilters filtertype);
};

#endif
